% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_information.R
\name{exp_decay}
\alias{exp_decay}
\alias{exp_decay.default}
\alias{exp_decay.numeric}
\alias{exp_decay.matrix}
\alias{exp_decay.ts}
\alias{exp_decay.xts}
\alias{exp_decay.data.frame}
\alias{exp_decay.tbl}
\title{Full Information by Exponential Decay}
\usage{
exp_decay(x, lambda)

\method{exp_decay}{default}(x, lambda)

\method{exp_decay}{numeric}(x, lambda)

\method{exp_decay}{matrix}(x, lambda)

\method{exp_decay}{ts}(x, lambda)

\method{exp_decay}{xts}(x, lambda)

\method{exp_decay}{data.frame}(x, lambda)

\method{exp_decay}{tbl}(x, lambda)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{lambda}{A number for the decay parameter.}
}
\value{
A numerical vector of class \code{ffp} with the new
probabilities distribution.
}
\description{
Exponential smoothing twists probabilities by giving relatively more weight
to recent observations at an exponential rate.
}
\details{
The half-life is linked with the lambda parameter as follows:
\itemize{
\item \code{HL = log(2) / lambda}.
}

For example: log(2) / 0.0166 is approximately 42. So, a parameter \code{lambda} of 0.0166 can be associated with a half-life of two-months.
}
\examples{
library(ggplot2)

# long half_life
long_hl <- exp_decay(EuStockMarkets, 0.001)
long_hl
autoplot(long_hl) +
  scale_color_viridis_c()

# short half_life
short_hl <- exp_decay(EuStockMarkets, 0.015)
short_hl
autoplot(short_hl) +
  scale_color_viridis_c()
}
\seealso{
\code{\link{crisp}} \code{\link{kernel_normal}} \code{\link{half_life}}
}
