% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-bbmk-test.R
\name{plot_bbmk_test}
\alias{plot_bbmk_test}
\title{Plot Block‐Bootstrap Mann–Kendall Test Results}
\usage{
plot_bbmk_test(results, ...)
}
\arguments{
\item{results}{List of BB‐MK test results generated by \code{\link[=eda_bbmk_test]{eda_bbmk_test()}}.}

\item{...}{Optional named arguments: 'title', 'xlabel', and 'ylabel'.}
}
\value{
\code{ggplot}; A plot containing:
\itemize{
\item A gray histogram of the distribution of bootstrapped S‐statistics.
\item A red vertical line at the lower and upper confidence bounds.
\item A black vertical line at the observed S‐statistic.
}
}
\description{
Generates a histogram of bootstrapped Mann–Kendall S‐statistics with vertical
lines indicating the observed S‐statistic and confidence bounds.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
results <- eda_bbmk_test(data, samples = 1000L)
plot_bbmk_test(results)

}
