% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_plot.R
\name{coef_plot}
\alias{coef_plot}
\title{Plots the coefficients of FERGM and potentially ERGM objects.}
\usage{
coef_plot(fergm.fit = NULL, ergm.fit = NULL, custom_var_names = NULL)
}
\arguments{
\item{fergm.fit}{Output object from the fergm function.}

\item{ergm.fit}{An ergm object containing the same model terms as the fergm object in the same formula order}

\item{custom_var_names}{Custom variable names to use that match the order of the form object passed to FERGM.}
}
\value{
This prints a coefficient "rope ladder" plot
}
\description{
This function allows the users to compare the coefficients of ERGMs and FERGMs
}
\examples{
# load example data
data("ergm.fit")
data("fergm.fit")
data("mesa")
# Compare substantive implications via coef plot, these are with 95\% credible intervals
coef_plot(fergm.fit = fergm.fit, ergm.fit = ergm.fit,
custom_var_names =  c("Edges", "Sex Homophily", "Grade Homophily",
"Race Homophily", "GWESP", "Alternating K-Stars"))
coef_plot(fergm.fit = fergm.fit,
custom_var_names =  c("Edges", "Sex Homophily", "Grade Homophily",
"Race Homophily", "GWESP", "Alternating K-Stars"))
}
\references{
Box-Steffensmeier, Janet M., Dino P. Christenson, and Jason W. Morgan. 2017. ``Modeling Unobserved Heterogeneity in Social Networks with the Frailty Exponential Random Graph Model." \emph{Political Analysis}.

Stan Development Team (2016). RStan: the R interface to Stan. R package version 2.14.1. \url{http://mc-stan.org/}.
}
\keyword{FERGM}
\keyword{interpret}
\keyword{summary}
