% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedstat_get_data_ids_special_cases_handle.R
\name{fedstat_get_data_ids_special_cases_handle}
\alias{fedstat_get_data_ids_special_cases_handle}
\title{Handle special cases strings for \code{filter_value_title} col in \code{data_ids}}
\usage{
fedstat_get_data_ids_special_cases_handle(
  data_ids,
  filter_value_title_alias_lookup_table = data.frame(filter_value_title = character(),
    filter_value_title_alias = character(), stringsAsFactors = FALSE)
)
}
\arguments{
\item{data_ids}{data.frame, result of \code{fedstat_get_data_ids}}

\item{filter_value_title_alias_lookup_table}{data.frame with columns \code{filter_value_title} and \code{filter_value_title_alias}.
Used to replace \code{filter_value_title} with standard forms of filter value titles.
It is mainly used to set consistent names.
For example, the Dalnevostochnyj federalnyj okrug ( s 03.11.2018) (transliteration for CRAN) in \code{filter_value_title}
can be simply replaced with \code{filter_value_title_alias} as Dalnevostochnyj federalnyj okrug.
In this example in fact, these are two different entities (after the inclusion of Buryatia and Transbaikalia and before),
but in most cases such a replacement is more convenient for loading data, since you need the whole time series.
By default it's empty data.frame, e.g. no replacement for anything.}
}
\value{
data.frame, data_ids with replaced by aliases \code{filter_value_title} column
and a new column \code{filter_value_title_week}, which consists only of NA in case of non-weekly data
}
\description{
Handles special cases strings in \code{filter_value_title} to standardize them.
Currently does only 2 things:
\enumerate{
\item Replaces \code{filter_value_title} with given aliases in \code{filter_value_title_alias_lookup_table};
\item Replaces week period titles with week numbers to filter
by it instead of a complex unstandardized "period" string
and adds a new column \code{filter_value_title_week} for weekly data
for using original week title if needed;
}

Function will be supplemented with new methods for processing special cases as they are found
}
\examples{
\dontrun{
# Get data filters identificators for week prices
# and standardize names for DVFO and extract week numbers
data_ids_special_cases_handled <- fedstat_get_data_ids("37426") \%>\%
  fedstat_get_indicator_data_ids_special_cases_handle(
    filter_value_title_alias_lookup_table = data.frame(
      "filter_value_title" = "Dalnevostochnyj federalnyj okrug ( s 03.11.2018)",
      "filter_value_title_alias" = "Dalnevostochnyj federalnyj okrug"
    )
  )
# In this example names for Far Eastern Federal District are latinized for CRAN
}
}
\seealso{
\code{\link{fedstat_get_data_ids}}
}
