
<!-- README.md is generated from README.Rmd. Please edit that file -->

# fedstatAPIr

<!-- badges: start -->
<!-- badges: end -->

fedstatAPIr представляет собой неофициальное API для загрузки данных с
fedstat.ru (система ЕМИСС Росстата) с заданными фильтрами.

Пакет позволяет сэкономить ⏳ и нервы 😡 при работе с бесконечно падающим
ЕМИСС через автоматическое повторение неотвеченных запросов и сохранение
ранее использованных настроек фильтров.

## Установка

На данный момент пакет доступен только на R, Вы можете загрузить
fedstatAPIr из [CRAN](https://CRAN.R-project.org), используя следующую
команду в R:

``` r
install.packages("fedstatAPIr")
```

Версия для разработки может быть загружена следующей командой:

``` r
# install.packages("devtools")
devtools::install_github("DenchPokepon/fedstatAPIr")
```

## Использование

Загрузим данные по инфляции к предыдущему месяцу и к соотв. месяцу
прошлого года за июнь 2021 года по всем товарам и услугам только по
России

Возьмем номер индикатора из URL веб страницы с данными
<https://fedstat.ru/indicator/31074>

``` r
library(fedstatAPIr)
data <- fedstat_data_load_with_filters(
  indicator_id = "31074",
  filters = list(
    "Классификатор объектов административно-территориального деления (ОКАТО)" = "Российская Федерация",
    "Виды показателя" = c(
      "К соответствующему кварталу предыдущего года",
      "К предыдущему месяцу"
    ),
    "Период" = "Июнь",
    "Год" = "2021",
    "Виды товаров и услуг" = "*"
  )
)
```

| EI      | ObsValue | PERIOD | Time | s_POK                | s_grtov                                             | s_OKATO              | s_OKATO_code | s_POK_code | s_grtov_code |
|:--------|:---------|:-------|:-----|:---------------------|:----------------------------------------------------|:---------------------|:-------------|:-----------|:-------------|
| процент | 100,69   | июнь   | 2021 | К предыдущему месяцу | Все товары и услуги                                 | Российская Федерация | 643          | 44         | 1            |
| процент | 100,66   | июнь   | 2021 | К предыдущему месяцу | Все товары                                          | Российская Федерация | 643          | 44         | 2            |
| процент | 100,75   | июнь   | 2021 | К предыдущему месяцу | Базовый индекс потребительских цен                  | Российская Федерация | 643          | 44         | 3            |
| процент | 100,7    | июнь   | 2021 | К предыдущему месяцу | Все товары (без алкогольных напитков)               | Российская Федерация | 643          | 44         | 4            |
| процент | 100,71   | июнь   | 2021 | К предыдущему месяцу | Продовольственные товары (без алкогольных напитков) | Российская Федерация | 643          | 44         | 5            |
| процент | 100,64   | июнь   | 2021 | К предыдущему месяцу | Продовольственные товары                            | Российская Федерация | 643          | 44         | 6            |

## Спецификация фильтров

Фильтры задаются в форме JSON:

``` json_example
{
 "Название поля фильтра 1": ["Значение фильтра 1", "Значение фильтра 2"],
 "Название поля фильтра 2": ["Значение фильтра 1", "Значение фильтра 2"],
 ...
}
```

Где `Название поля фильтра 1` может быть, например `Год`, а
`Значение фильтра 1` для этого поля `2021`.

Поля и значения фильтров берутся прямо из названий фильтров на
fedstat.ru, в `filters` они должны быть такими же. Однако разные
регистры фильтров и лишние пробелы не сломают фильтрацию.

Доступны следующие специальные значения фильтров:

1.  Звездочка/asterix (\*) выбирает все данные по этому полю фильтра.

Можно не указывать какой-то фильтр вообще, тогда по умолчанию будет
использоваться \*.

## Доступные индикаторы

Библиотека стремится поддерживать загрузку всех доступных на fedstat
индикаторов, на данный момент поддерживается абсолютное большинство, но
в некоторых случаях специальных индикаторов могут быть непредвиденные
баги.

Внутри пакета доступна база данных всех индикаторов, по которым
представлены данные на fedstat.ru. Она содержится в переменной
`fedstat_indicators_names_database`.

## Мониторинг обновления индикаторов

В последнем обновлении пакета были добавлены функции
`fedstat_prepare_reference_data_for_check_data_update` и
`fedstat_check_data_update`. С их помощью можно запустить робота в R,
делающего запросы к fedstat.ru и проверяющего, не появились ли данные за
новые временные промежутки. На данный момент функции экспериментальные,
так как не были протестированы на реальных данных, будем рады Вашим
отзывам.

Проверить, когда последний раз обновлялись данные на fedstat простым
запросом, к сожалению, невозможно. Даты обновления живут своей жизнью и
часто не соответствуют действительности. Для точной проверки нужно
сравнивать прошлые и новые данные.

Ниже представлен пример использования.
`fedstat_prepare_reference_data_for_check_data_update` кэширует прошлые
данные, желательно брать какую-то маленькую выборку для снижения
нагрузки на сервер. `fedstat_check_data_update` по умолчанию каждые 30
минут делает запрос к fedstat с такими же основными фильтрами и сверяет
новые и старые данные, в случае обнаружения изменений возвращает TRUE.

``` r
is_updated <- fedstat_prepare_reference_data_for_check_data_update(
  indicator_id = "37426",
  filters = list(
    "Territory" = "Российская Федерация",
    "Types of goods and services" = "Сахар"
  )
) %>%
  fedstat_check_data_update()

if (is_updated) print("Data for the indicator 37426 has been updated!")
```

## Продвинутое использование

Функция `fedstat_data_load_with_filters` является оберткой из отдельных
функций, которые отвечают за:

1.  Загрузку id фильтров через GET запрос (`fedstat_get_data_ids`);
2.  Обработку специальных случаев названий фильтров
    (`fedstat_get_data_ids_special_cases_handle`);
3.  Фильтрацию данных на основе `filters` с учетом специальных значений
    и стандартных фильтров (`fedstat_data_ids_filter`);
4.  Отправку POST запроса с телом из фильтров
    (`fedstat_post_data_ids_filtered`);
5.  Парсинг полученного sdmx файла в таблицу
    (`fedstat_parse_sdmx_to_table`).

По каждой функции доступна подробная документация, которую можно вызвать
в R через функцию `help()`. Например
`help("fedstat_data_load_with_filters")` или
`?fedstat_data_load_with_filters`.

Загрузим те же данные, используя каждую функцию отдельно

``` r
data_ids <- fedstat_get_data_ids("31074") # Занимает много времени из-за лагов
# fedstat, для скорости лучше всего кэшировать или даже записывать в базу данных,
# более подробно по этому моменту в документации

data_ids_filtered <- data_ids %>%
  fedstat_get_data_ids_special_cases_handle() %>%
  fedstat_data_ids_filter(
    filters = list(
      "Классификатор объектов административно-территориального деления (ОКАТО)" = "Российская Федерация",
      "Виды показателя" = c(
        "К соответствующему кварталу предыдущего года",
        "К предыдущему месяцу"
      ),
      "Период" = "Июнь",
      "Год" = "2021",
      "Виды товаров и услуг" = "*"
    )
  )

data_sdmx_parsed <- data_ids_filtered %>%
  fedstat_post_data_ids_filtered(data_format = "sdmx") %>%
  fedstat_parse_sdmx_to_table()

data_xls_binary <- data_ids_filtered %>%
  fedstat_post_data_ids_filtered(data_format = "excel") # также можем загружать excel

writeBin(data_xls_binary, "data.xls") # можем записать в xls файл
```

## Помощь

Вопросы можно писать на почту <deniskrylovvit@gmail.com>

------------------------------------------------------------------------

## Разработка

Проект находится на ранней стадии разработки.

Буду рад Вашему вкладу в проект.
