% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AmplitudeBoxplot.R
\name{AmplitudeBoxplot}
\alias{AmplitudeBoxplot}
\title{SRVF transform of warping functions}
\usage{
AmplitudeBoxplot(fn, fmedian, qn, qmedian, time, ka, showplot = T)
}
\arguments{
\item{fn}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} aligned functions with \eqn{N} samples}

\item{fmedian}{vector of \eqn{M} samples of the median calculated using \code{\link{time_warping}} with median}

\item{qn}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} of aligned srvfs}

\item{qmedian}{vector of \eqn{M} samples of the median calculated using \code{\link{time_warping}} with median}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{ka}{scalar for outlier cutoff}

\item{showplot}{shows plots of functions (default = T)}
}
\value{
Returns a list containing \item{median_y}{median function}
\item{Q1}{First quartile}
\item{Q3}{Second quartile}
\item{minn}{minimum extreme function}
\item{maxx}{maximum extreme function}
\item{outlier_index}{indexes of outlier functions}
}
\description{
This function calculates the srvf of warping functions with corresponding
shooting vectors and finds the median
}
\examples{
data("simu_warp_median")
data("simu_data")
out = AmplitudeBoxplot(simu_warp_median$fn, simu_warp_median$fmean, simu_warp_median$qn,
                       simu_warp_median$mqn, simu_data$time, 1)
}
\references{
Xie, W., S. Kurtek, K. Bharath, and Y. Sun  (2016). "A Geometric Approach to Visualization
of Variability in Functional Data." Journal of the American Statistical Association in press: 1-34.
}
\keyword{alignment}
\keyword{boxplot}
\keyword{srvf}
