% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgname.R
\docType{package}
\name{fdapace}
\alias{fdapace}
\title{fdapace: Principal Analysis by Conditional Expectation and Applications in
Functional Data Analysis (revised version 16 August 2019)}
\description{
fdapace for Functional Data Analysis
}
\details{
fdapace is a versatile package that provides implementation of various methods
of Functional Data Analysis (FDA) and Empirical Dynamics. The core of this
package is Functional Principal Component Analysis (FPCA), a key technique
for functional data analysis, for sparsely or densely sampled random
trajectories and time courses, via the Principal Analysis by Conditional
Estimation (PACE) algorithm. This core algorithm yields covariance and mean functions, eigenfunctions and principal 
component (scores), for both functional data and derivatives, for both dense (functional)
and sparse (longitudinal) sampling designs. For sparse designs, it provides fitted continuous 
trajectories with confidence bands, even for subjects with very few longitudinal observations. 
PACE is a viable and flexible alternative to random effects modeling
of longitudinal data. There is also a Matlab version (PACE) that contains some methods not available on fda-pace and vice versa.

References: Wang, J.L., Chiou, J.,  Müller, H.G. (2016). Functional data analysis. Annual Review of Statistics and Its Application 3, 257--295
Chen, K., Zhang, X., Petersen, A., Müller, H.G.  (2017). Quantifying infinite-dimensional data: Functional Data Analysis in action. 
Statistics in Biosciences 9, 582–-604.

Links for fda-pace/PACE:
Matlab version of pace at http://anson.ucdavis.edu/~mueller/data/pace.html
Papers and background at http://anson.ucdavis.edu/~mueller/  and  http://www.stat.ucdavis.edu/~wang/



PACE is based on the idea that observed functional data
are generated by a sample of underlying (but usually not fully
observed) random trajectories that are realizations of a stochastic process. It does not rely on pre-smoothing of
trajectories, which is problematic if functional data are sparsely sampled.

The functional principal components can be used for further statistical analysis depending on 
the demands of a user, for example if one has densely sampled functional predictors and a generalized 
response, such as in a GLM, the predictor functions can be replaced by their first couple of principal component scores that
will then be used as predictors; one can also easily fit polynomial functional models by using powers (usually squares) 
and interactions of functional principal 
components among the predictors for a scalar response. 

fda-pace is a comprehensive package that directly implements fitting of the following models:
-- functional linear regression 
-- functional additive regression
-- functional covariance and correlation (via dynamic correlation) 
-- functional clustering 
-- concurrent (varying coefficient) regression models for sparse and dense designs
-- varying coefficient additive models
-- multivariate functional data analysis (normalization and functional singular component analysis)
-- variance processes and volatility processes (the latter of interest in finance)
-- optimal designs for longitudinal data analysis (for trajectory prediction and for functional linear regression) 
-- stringing, a method to convert high-dimensional data into functional data
-- quantile regression, with functions as predictors
 
 

Maintainer:  Yaqing Chen \email{yaqchen@ucdavis.edu}
}
\author{
Yaqing Chen \email{yaqchen@ucdavis.edu}
Cody Carroll \email{cjcarroll@ucdavis.edu}
Xiongtao Dai \email{dai@ucdavis.edu}
Jianing Fan
Pantelis Z. Hadjipantelis 
Kyunghee Han 
Hao Ji
 
Hans-Georg Müller \email{hgmueller@ucdavis.edu}
Jane-Ling Wang \email{janelwang@ucdavis.edu}
}
