% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSVD.R
\name{FSVD}
\alias{FSVD}
\title{Functional Singular Value Decomposition}
\usage{
FSVD(Ly1, Lt1, Ly2, Lt2, FPCAoptns1 = NULL, FPCAoptns2 = NULL,
  SVDoptns = list())
}
\arguments{
\item{Ly1}{A list of \emph{n} vectors containing the observed values for each individual. Missing values specified by \code{NA}s are supported for dense case (\code{dataType='dense'}).}

\item{Lt1}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to y. Each vector should be sorted in ascending order.}

\item{Ly2}{A list of \emph{n} vectors containing the observed values for each individual. Missing values specified by \code{NA}s are supported for dense case (\code{dataType='dense'}).}

\item{Lt2}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to y. Each vector should be sorted in ascending order.}

\item{FPCAoptns1}{A list of options control parameters specified by \code{list(name=value)} for the FPC analysis of sample 1. See `?FPCA'.}

\item{FPCAoptns2}{A list of options control parameters specified by \code{list(name=value)} for the FPC analysis of sample 2. See `?FPCA'.}

\item{SVDoptns}{A list of options control parameters specified by \code{list(name=value)} for the FSVD analysis of samples 1 & 2. See `Details`.}
}
\value{
A list containing the following fields:
\item{bw1}{The selected (or user specified) bandwidth for smoothing the cross-covariance function across the support of sample 1.}
\item{bw2}{The selected (or user specified) bandwidth for smoothing the cross-covariance function across the support of sample 2.}
\item{CrCov}{The smoothed cross-covariance between samples 1 & 2.}
\item{sValues}{A list of length \emph{nsvd}, each entry containing the singuar value estimates for the FSC estimates.}
\item{nsvd}{The number of singular componentes used.}
\item{canCorr}{The canonical correlations for each dimension.}
\item{FVE}{A percentage indicating the total variance explained by chosen FSCs with corresponding 'FVEthreshold'.}
\item{sFun1}{An nWorkGrid by \emph{K} matrix containing the estimated singular functions for sample 1.}
\item{sFun2}{An nWorkGrid by \emph{K} matrix containing the estimated singular functions for sample 2.}
\item{grid1}{A vector of length nWorkGrid1. The internal regular grid on which the singular analysis is carried on the support of sample 1.}
\item{grid2}{A vector of length nWorkGrid2. The internal regular grid on which the singular analysis is carried on the support of sample 2.}
\item{sScores1}{A \emph{n} by \emph{K} matrix containing the singular scores for sample 1.}
\item{sScores2}{A \emph{n} by \emph{K} matrix containing the singular scores for sample 2.}
\item{optns}{A list of options used by the SVD and the FPCA's procedures.}
}
\description{
FSVD for a pair of dense or sparse functional data.
}
\details{
Available control options for SVDoptns are: 
\describe{
\item{bw1}{The bandwidth value for the smoothed cross-covariance function across the direction of sample 1; positive numeric - default: determine automatically based on 'methodBwCov'}
\item{bw2}{The bandwidth value for the smoothed cross-covariance function across the direction of sample 2; positive numeric - default: determine automatically based on 'methodBwCov'}
\item{methodBwCov}{The bandwidth choice method for the smoothed covariance function; 'GMeanAndGCV' (the geometric mean of the GCV bandwidth and the minimum bandwidth),'CV','GCV' - default: 10\% of the support}
\item{userMu1}{The user defined mean of sample 1 used to centre it prior to the cross-covariance estimation. - default: determine automatically based by the FPCA of sample 1}
\item{userMu2}{The user defined mean of sample 2 used to centre it prior to the cross-covariance estimation. - default: determine automatically based by the FPCA of sample 2}
\item{maxK}{The maximum number of singular components to consider; default: min(20, N-1), N:# of curves.}
\item{kernel}{Smoothing kernel choice, common for mu and covariance; "rect", "gauss", "epan", "gausvar", "quar" - default: "gauss"; dense data are assumed noise-less so no smoothing is performed.}
\item{rmDiag}{Logical describing if the routine should remove diagonal raw cov for cross cov estimation (default: FALSE) }
\item{noScores}{Logical describing if the routine should return functional singular scores or not (default: TRUE) }
\item{regulRS}{String describing if the regularisation of the compositie cross-covariance matrix should be done using 'sigma1' or 'rho' (see ?FPCA for details) (default: 'sigma2') }
\item{bwRoutine}{String specifying the routine used to find the optimal bandwidth 'grid-search', 'bobyqa', 'l-bfgs-b' (default: 'l-bfgs-b')}
\item{flip}{Logical describing if the routine should flip the sign of the singular components functions or not after the SVD of the cross-covariance matrix. (default: FALSE)}
\item{useGAM}{Indicator to use gam smoothing instead of local-linear smoothing (semi-parametric option) (default: FALSE)}
\item{dataType1}{The type of design we have for sample 1 (usually distinguishing between sparse or dense functional data); 'Sparse', 'Dense', 'DenseWithMV' - default:  determine automatically based on 'IsRegular'}
\item{dataType2}{The type of design we have for sample 2 (usually distinguishing between sparse or dense functional data); 'Sparse', 'Dense', 'DenseWithMV' - default:  determine automatically based on 'IsRegular'}
}
}

