% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeDENsample.R
\name{MakeDENsample}
\alias{MakeDENsample}
\title{Convenience function for converting log quantile densities to densities}
\usage{
MakeDENsample(
  qmatrix,
  lqdSup = seq(0, 1, length.out = ncol(qmatrix)),
  dSup = seq(0, 1, length.out = ncol(qmatrix)),
  useAlpha = FALSE,
  alpha = 0
)
}
\arguments{
\item{qmatrix}{Matrix holding the log quantile density values on [0,1]}

\item{lqdSup}{Support grid for input log quantile densities (default = seq(0, 1, length.out = ncol(qmatrix)))}

\item{dSup}{Support grid for output densities (default = seq(0, 1, length.out = ncol(qmatrix)))}

\item{useAlpha}{Logical indicator to deregularise the densities (default = FALSE)}

\item{alpha}{Scalar to deregularise the density - where possible, this will be the minimum value for the deregularised densities (default=0)}
}
\value{
list with the 'DEN' transformed data, and 'dSup' that matches the input argument.
}
\description{
See 'lqd2dens' and 'DeregulariseByAlpha' for more details.
This function transforms the log quantile densities in 'qmatrix' to density functions, optionally followed by deregularisation.
}
\examples{
 

x <- seq(0,1,length.out = 101)
# linear densities on (0, 1)
y <- t(sapply(seq(0.5, 1.5, length.out = 10), function(b) b + 2*(1 - b)*x)) 

# Get LQDs

y.lqd = MakeLQDsample(dmatrix = y, dSup = x)
matplot(y.lqd$lqdSup, t(y.lqd$LQD), ylab = 'LQD', type = 'l', lty = 1, col = 'black')

# Get Densities Back

y.dens = MakeDENsample(y.lqd$LQD, lqdSup = x, dSup = x) # should equate to y above
# These should look the same
matplot(y.dens$dSup, t(y.dens$DEN), ylab = 'Density', type = 'l', lty = 1, col = 'blue')
matplot(x, t(y), ylab = 'Original Density', type = 'l', lty = 1, col = 'red')

}
\references{
\cite{Functional Data Analysis for Density Functions by Transformation to a Hilbert space, Alexander Petersen and Hans-Georg Mueller, 2016}
}
\seealso{
\code{\link{DeregulariseByAlpha},\link{lqd2dens}}
}
