% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{image.FEM.time}
\alias{image.FEM.time}
\title{Image plot of a 2D FEM.time object at a given time}
\usage{
\method{image}{FEM.time}(x,t,lambdaS=1,lambdaT=1,num_refinements=NULL,...)
}
\arguments{
\item{x}{A 2D-mesh \code{FEM.time} object.}

\item{t}{time at which do the plot}

\item{lambdaS}{index of the space penalization parameter to use for the plot, useful when \code{FEM.time} returned by \code{smooth.FEM.time} using GCV}

\item{lambdaT}{index of the time penalization parameter to use for the plot, useful when \code{FEM.time} returned by \code{smooth.FEM.time} using GCV}

\item{num_refinements}{A natural number specifying how many bisections should by applied to each triangular element for
plotting purposes. This functionality is useful where a discretization with 2nd order Finite Element is applied.}

\item{...}{Arguments representing  graphical options to be passed to \link[rgl]{plot3d}.}
}
\description{
Image plot of a \code{FEM.time} object, generated by the function \code{FEM.time} or returned by
\code{smooth.FEM.time}. Only FEM objects defined over a 2D mesh can be plotted with this method.
}
\examples{
library(fdaPDE)
## Upload the horseshoe2D data
data(horseshoe2D)
boundary_nodes = horseshoe2D$boundary_nodes
boundary_segments = horseshoe2D$boundary_segments
locations = horseshoe2D$locations

## Create the 2D mesh
mesh = create.mesh.2D(nodes = rbind(boundary_nodes, locations), segments = boundary_segments)
## Create the FEM basis
FEMbasis = create.FEM.basis(mesh)
## Compute the coeff vector evaluating the desired function at the mesh nodes
## In this case we consider the fs.test() function introduced by Wood et al. 2008
time = 1:5
coeff = rep(fs.test(mesh$nodes[,1], mesh$nodes[,2]),5)*time
## Create the FEM.time object
FEM_time_function = FEM.time(coeff=coeff, time_mesh=1:5,FEMbasis=FEMbasis,FLAG_PARABOLIC=TRUE)

## Plot the FEM function
t = c(1.2,1.5,3.6,2.4,4.5)
image(FEM_time_function,t)
}
\seealso{
\code{\link{FEM.time}} \code{\link{image.FEM.time}}
}
