% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdaPDE.objects.R
\name{create.FEM.basis}
\alias{create.FEM.basis}
\title{Create a FEM basis}
\usage{
create.FEM.basis(mesh)
}
\arguments{
\item{mesh}{A \code{MESH2D}  object representing the domain triangulation. See \link{create.MESH.2D}.}
}
\value{
A  \code{FEMbasis} object. This contains the \code{mesh}, along with some additional quantities:
\item{\code{order}}{Either "1" or "2". Order of the Finite Element basis.} 
\item{\code{nbasis}}{Scalar. The number of basis.} 
\item{\code{detJ}}{The determinant of the transformation from the nodes of the reference triangle to the nodes of the i-th triangle; this coincides with the double of the area of the i-th triangle.} 
\item{\code{transf}}{A three-dimensional array such that  \code{transf[i,,]} is the 2-by-2 matrix that transforms the nodes of the reference triangle to the nodes of the i-th triangle.}
\item{\code{metric}}{A three-dimensional array such that \code{metric[i,,]} is the 2-by-2 matrix \cr 
\code{transf[i,,]^{-1}*transf[i,,]^{-T}}. This matrix is used for the computation
of the integrals over the elements of the mesh.}
}
\description{
Sets up a Finite Element basis. It requires a triangular mesh, a \code{MESH2D} object, as input. 
The basis' functions are globally continuos surfaces, that are polynomials once restricted to a triangle in the mesh. 
Linear if (\code{order = 1}) in the input \code{mesh} and quadratic if (\code{order = 2}) in the input \code{mesh}
Finite Element are currently implemented.
}
\examples{
## Creates a simple triangulated domain with a concavity; this is a MESH2D object  
mesh<-create.MESH.2D(nodes=rbind(c(0, 0), c(0, 1), c(0.5, 0.5), c(1, 1), c(1, 0)),
segments=rbind(c(1, 2), c(2, 3), c(3, 4), c(4, 5), c(5, 1)), order=1)
## Plot it
plot(mesh)                   
## Creates the basis
FEMbasis = create.FEM.basis(mesh)
}
\seealso{
\code{\link{create.MESH.2D}}
}
