% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fda.usc.internal.R
\name{fda.usc.internal}
\alias{fda.usc.internal}
\alias{trace.matrix}
\alias{[.fdata}
\alias{[.fdist}
\alias{+.fdata}
\alias{-.fdata}
\alias{*.fdata}
\alias{/.fdata}
\alias{c.fdata}
\alias{==.fdata}
\alias{!=.fdata}
\alias{dim.fdata}
\alias{ncol.fdata}
\alias{nrow.fdata}
\alias{NROW.fdata}
\alias{NCOL.fdata}
\alias{length.fdata}
\alias{^.fdata}
\alias{argvals}
\alias{rangeval}
\alias{missing.fdata}
\alias{omit.fdata}
\alias{omit2.fdata}
\alias{is.na.fdata}
\alias{anyNA.fdata}
\alias{count.na.fdata}
\alias{colnames.fdata}
\alias{rownames.fdata}
\alias{fdata.trace}
\alias{argvals.equi}
\alias{unlist_fdata}
\title{fda.usc internal functions}
\usage{
trace.matrix(x, na.rm = TRUE)

argvals.equi(tt)

\method{+}{fdata}(fdata1, fdata2)

\method{-}{fdata}(fdata1, fdata2)

\method{*}{fdata}(fdata1, fdata2)

\method{/}{fdata}(fdata1, fdata2)

\method{[}{fdata}(fdataobj, i = TRUE, j = TRUE, drop = FALSE)

\method{!=}{fdata}(fdata1, fdata2)

\method{==}{fdata}(fdata1, fdata2)

\method{^}{fdata}(fdataobj, pot)

\method{dim}{fdata}(x)

ncol.fdata(x)

nrow.fdata(x)

\method{length}{fdata}(x)

NROW.fdata(x)

NCOL.fdata(x)

rownames.fdata(x)

colnames.fdata(x)

\method{c}{fdata}(...)

argvals(fdataobj)

rangeval(fdataobj)

\method{[}{fdist}(fdataobj, i = TRUE, j = TRUE, drop = FALSE)

\method{is.na}{fdata}(x)

\method{anyNA}{fdata}(x, recursive = FALSE)

count.na.fdata(x)

unlist_fdata(x, recursive = TRUE, use.names = TRUE)
}
\arguments{
\item{x}{\code{matrix} or \code{fdata} class object.}

\item{na.rm}{\code{logical}. Should missing values (including \code{NaN}) be removed?}

\item{tt}{Argvals}

\item{fdataobj, fdata1, fdata2}{\code{fdata} class object.}

\item{i, j}{Indices specifying elements to extract, replace. Indices are numeric or character vectors or empty}

\item{drop}{For \code{fdata} class object. If TRUE the result is coerced to the lowest possible dimension of  element \code{data}. This only works for extracting elements, not for the replacement.}

\item{pot}{Numeric value for exponentiation.}

\item{\dots}{\code{fdata} objects to be concatenated.}

\item{recursive}{should \code{anyNA} be applied recursively to lists and pairlists? (in  anyNA.fdata function)
\code{logical} Should unlisting be applied to list components of x? (in unlist_fdata function).}

\item{use.names}{\code{logical} Should names be preserved?}
}
\description{
Internal undocumentation functions for fda.usc package.
}
\details{
\code{argvals.equi} function returns \code{TRUE} if the argvals are equispaced 
and \code{FALSE} in othercase.
}
\note{
In "Ops" functions \code{"+.fdata"}, \code{"-.fdata"}, \code{"*.fdata"} and 
\code{"/.fdata"}: The lengths of the objects \code{fdata1} and \code{fdata2} may
be different because operates recycled into minimum size as necessary.
}
\references{
Febrero-Bande,  M., Oviedo de la Fuente, M. (2012).  \emph{Statistical Computing
 in Functional Data Analysis: The R Package fda.usc.}  Journal of Statistical Software, 
 51(4), 1-28. \doi{10.18637/jss.v051.i04}
}
\keyword{math}
