\name{min.basis}
\Rdversion{1.1}
\alias{min.basis}
\title{ Select the number of basis using GCV method.}
\description{
Functional data estimation via basis representation using cross-validation (CV) or generalized cross-validation (GCV) method with a roughness penalty. 
}
\usage{
%min.basis(fdataobj,type.CV=GCV.S,W=diag(1,ncol=np,nrow=np),lambda=0,
%numbasis=floor(seq(ncol(fdataobj)/16,ncol(fdataobj)/2,len=10)),
%type.basis="bspline",par.CV=list(trim=0,draw=FALSE),...) 
\method{min}{basis}(fdataobj,type.CV=GCV.S,W=diag(1,ncol=np,nrow=np),lambda=0,
numbasis=floor(seq(ncol(fdataobj)/16,ncol(fdataobj)/2,len=10)),
type.basis="bspline",par.CV=list(trim=0,draw=FALSE),\dots)
}

\arguments{
  \item{fdataobj}{ \code{\link{fdata}} class object.}    
  \item{type.CV}{ Type of cross-validation. By default generalized cross-validation (GCV) method.}
  \item{W}{ Matrix of weights.}
  \item{lambda}{ A roughness penalty. By default, no penalty \code{lambda=0}.}
  \item{numbasis}{ Number of basis to use.}
  \item{type.basis}{ Character string which determines type of basis. By default \emph{"bspline"}.}
  \item{par.CV}{ List of parameters for type.CV: trim, the alpha of the trimming and \code{draw=TRUE}.}	  
   \item{\dots}{ Further arguments passed to or from other methods. Arguments to be passed by default to \link[fda]{create.basis}. }
}

\details{  
Provides the least GCV for functional data for a list of number of basis \code{num.basis} and lambda values \code{lambda}.
You can define the type of CV to use with the \code{type.CV}, the default is used \code{GCV.S}. \cr
Smoothing  matrix is performed by \code{\link{S.basis}}. \code{W} is the matrix of weights of the discretization points.
}
\value{
    \item{gcv}{ Returns GCV values calculated for input parameters.}
  \item{fdataobj}{ Matrix  of  set cases with dimension (\code{n} x \code{m}), where \code{n} is the number of curves and \code{m} are the points observed in each curve.}
	  \item{fdata.est}{ Estimated \code{fdata} class object.}
    \item{numbasis.opt}{ \code{numbasis} value that minimizes CV or GCV method.}
    \item{lambda.opt}{ \code{lambda} value that minimizes CV or GCV method.}
    \item{basis.opt}{ \code{basis} for the minimum  CV or GCV method.}
    \item{S.opt}{ Smoothing matrix for the minimum  CV or GCV method.}
    \item{gcv.opt}{ Minimum  of CV or GCV method.}
    \item{lambda}{ A roughness penalty. By default, no penalty \code{lambda=0}.}
    \item{numbasis}{ Number of basis to use.}
}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006), \emph{ Functional Data Analysis}, 2nd ed., Springer, New York. \cr

Wasserman, L. \emph{All of Nonparametric Statistics}. Springer Texts in Statistics, 2006. \cr

Hardle, W. \emph{Applied Nonparametric Regression}. Cambridge University Press, 1994.}
\author{
Febrero-Bande, M. and Oviedo de la Fuente, M.
}
\seealso{
See Also as  \code{\link{S.basis}}. \cr
Alternative method:  \code{\link{min.np}}
}

\examples{


a1<-seq(0,1,by=.01)
a2=rnorm(length(a1),sd=0.2)
f1<-(sin(2*pi*a1))+rnorm(length(a1),sd=0.2)
nc<-50
np<-length(f1)
tt=1:101
S<-S.NW(tt,2)
mdata<-matrix(NA,ncol=np,nrow=50)
for (i in 1:50) mdata[i,]<- (sin(2*pi*a1))+rnorm(length(a1),sd=0.2)
mdata<-fdata(mdata)
nb<-floor(seq(5,29,len=5))
l<-2^(-5:15)
out<-min.basis(mdata,lambda=l,numbasis=nb,type.basis="fourier")
matplot(t(out$gcv),type="l",main="GCV with fourier basis")

# out1<-min.basis(mdata,type.CV = CV.S,lambda=l,numbasis=nb)
# out2<-min.basis(mdata,lambda=l,numbasis=nb)

# variance calculations
y<-mdata
i<-3
z=qnorm(0.025/np)
fdata.est<-out$fdata.est
var.e<-Var.e(mdata,out$S.opt)
var.y<-Var.y(mdata,out$S.opt)
var.y2<-Var.y(mdata,out$S.opt,var.e)

# estimated fdata and point confidence interval
upper.var.e<-out$fdata.est[["data"]][i,]-z*sqrt(diag(var.e))
lower.var.e<-out$fdata.est[["data"]][i,]+z*sqrt(diag(var.e))
dev.new()
plot(y[i,],lwd=1,ylim=c(min(lower.var.e),max(upper.var.e)))
lines(out$fdata.est[["data"]][i,],col=gray(.1),lwd=1)
lines(out$fdata.est[["data"]][i,]+z*sqrt(diag(var.y)),col=gray(0.7),lwd=2)
lines(out$fdata.est[["data"]][i,]-z*sqrt(diag(var.y)),col=gray(0.7),lwd=2)
lines(upper.var.e,col=gray(.3),lwd=2,lty=2)
lines(lower.var.e,col=gray(.3),lwd=2,lty=2)
legend("top",legend=c("Var.y","Var.error"), col = c(gray(0.7),
gray(0.3)),lty=c(1,2))

}

\keyword{nonparametric} 