% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_name_labels.R
\name{fix_name_labels}
\alias{fix_name_labels}
\title{Fix name labels}
\usage{
fix_name_labels(x, pattern = NA, replacement = ".")
}
\arguments{
\item{x}{the vector or list to fix}

\item{pattern}{regex pattern to replace; defaults to non-word characters and the value of faux_options("sep") (default = _)}

\item{replacement}{the character to replace; defaults to . (or _ if faux_options("sep") == ".")}
}
\value{
a named list with fixed names
}
\description{
Fixes if a factor list does not have named levels or has special characters in the names
}
\examples{
source <- list("full.stop", " space ", "under_score", "plus+", "dash-", "tab\t", "line\nbreak")
fix_name_labels(source)

}
