% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{process_model}
\alias{process_model}
\title{Process Model and Compute Performance Metrics}
\usage{
process_model(model_obj, model_id, task, test_data, label, event_class, engine)
}
\arguments{
\item{model_obj}{A model object, which can be either a tuning result (an object inheriting from \code{"tune_results"}) or an already fitted workflow.}

\item{model_id}{A unique identifier for the model, used in warning messages if issues arise during processing.}

\item{task}{A character string indicating the type of task, either \code{"classification"} or \code{"regression"}.}

\item{test_data}{A data frame containing the test data on which predictions will be generated.}

\item{label}{A character string specifying the name of the outcome variable in \code{test_data}.}

\item{event_class}{For classification tasks, a character string specifying which event class to consider as positive (accepted values: \code{"first"} or \code{"second"}).}

\item{engine}{A character string specifying the modeling engine used. This parameter affects prediction types and metric computations.}
}
\value{
A list with two components:
  \describe{
    \item{performance}{A data frame of performance metrics. For classification tasks, metrics include accuracy, kappa, sensitivity, specificity, precision, F-measure, and ROC AUC (when applicable). For regression tasks, metrics include RMSE, R-squared, and MAE.}
    \item{predictions}{A data frame containing the test data augmented with predicted classes and, when applicable, predicted probabilities.}
  }
}
\description{
Finalizes a tuning result or utilizes an already fitted workflow to generate predictions on test data and compute performance metrics.
}
\details{
The function first checks if \code{model_obj} is a tuning result. If so, it attempts to:
  \itemize{
    \item Select the best tuning parameters using \code{tune::select_best} (note that the metric used for selection should be defined in the calling environment).
    \item Extract the model specification and preprocessor from \code{model_obj} using \code{workflows::pull_workflow_spec} and \code{workflows::pull_workflow_preprocessor}, respectively.
    \item Finalize the model specification with the selected parameters via \code{tune::finalize_model}.
    \item Rebuild the workflow using \code{workflows::workflow}, \code{workflows::add_recipe}, and \code{workflows::add_model}, and fit the finalized workflow with \code{parsnip::fit} on training data (the variable \code{train_data} is expected to be available in the environment).
  }
  If \code{model_obj} is already a fitted workflow, it is used directly.

  For classification tasks, the function makes class predictions (and probability predictions if \code{engine} is not \code{"LiblineaR"}) and computes performance metrics using functions from the \code{yardstick} package. In binary classification, the positive class is determined based on the \code{event_class} argument and ROC AUC is computed accordingly. For multiclass classification, macro-averaged metrics and ROC AUC (using weighted estimates) are calculated.

  For regression tasks, the function predicts outcomes and computes regression metrics (RMSE, R-squared, and MAE).

  If the number of predictions does not match the number of rows in \code{test_data}, the function stops with an informative error message regarding missing values and imputation options.
}
