% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositeRGB.r
\name{compositeRGB,GRaster-method}
\alias{compositeRGB,GRaster-method}
\alias{compositeRGB}
\title{Combine red, green, and blue color bands to make a composite GRaster}
\usage{
\S4method{compositeRGB}{GRaster}(r, g = NULL, b = NULL, levels = 256, dither = FALSE)
}
\arguments{
\item{r, g, b}{Either:
\itemize{
\item One \code{GRaster} with one band each for \code{r}, \code{g}, or \code{b} representing red, green, and blue color bands; or
\item \code{r} is  single \code{GRaster} with 3 bands (R, G, and B bands), and \code{g} and \code{b} are \code{NULL}.
}}

\item{levels}{Either a single value that is an integer, or a vector of integers: Number of levels of red, green, and blue intensities represented in \code{r}, \code{g}, and \code{b}. If a single value is supplied, it is assumed that all three have the same number of levels. If three values are supplied, then they correspond to the R, G, and B bands. The default is 256 (assume that R, G, and B rasters have values between 0 and 255).}

\item{dither}{Logical: If \code{TRUE}, apply Floyd-Steinberg dithering. Default is \code{FALSE}.}
}
\value{
A \code{GRaster}.
}
\description{
This function takes as arguments three rasters typically representing red, green, and blue color bands, and returns a single raster with values based on their combination. Typically, this raster should be plotted in grayscale.
}
\examples{
if (grassStarted()) {

# Example data
madElev <- fastData("madElev") # elevation raster
madLANDSAT <- fastData("madLANDSAT") # multi-layer raster
madRivers <- fastData("madRivers") # lines vector

# Convert SpatRaster to GRaster and SpatVector to GVector
elev <- fast(madElev)
rivers <- fast(madRivers)
landsat <- fast(madLANDSAT)

# Plot:
plot(elev)
plot(rivers, add = TRUE)

# Histograms:
hist(elev)
hist(landsat)

# Plot surface reflectance in RGB:
plotRGB(landsat, 3, 2, 1) # "natural" color
plotRGB(landsat, 4, 1, 2, stretch = "lin") # emphasize near-infrared (vegetation)

# Make composite map from RGB layers and plot in grayscale:
comp <- compositeRGB(r = landsat[[3]], g = landsat[[2]], b = landsat[[1]])
grays <- paste0("gray", 0:100)
plot(comp, col = grays)

}
}
\seealso{
\code{\link[=plotRGB]{plotRGB()}}, \code{\link[terra:plotRGB]{terra::plotRGB()}}, \strong{GRASS} manual page for module \code{r.composite} (see \code{grassHelp("r.composite")})
}
