% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd.R
\name{fastcpd_var}
\alias{fastcpd_var}
\alias{fastcpd.var}
\title{Find change points efficiently in VAR(\eqn{p}) models}
\usage{
fastcpd_var(data, order = 0, ...)

fastcpd.var(data, order = 0, ...)
}
\arguments{
\item{data}{A matrix, a data frame or a time series object.}

\item{order}{A positive integer specifying the order of the VAR model.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_var]{fastcpd_var()}} and \code{\link[=fastcpd.var]{fastcpd.var()}} are
wrapper functions of \code{\link[=fastcpd_ts]{fastcpd_ts()}} to find change points in
VAR(\eqn{p}) models. The function is similar to \code{\link[=fastcpd_ts]{fastcpd_ts()}}
except that the data is by default a matrix with row as an observation
and thus a formula is not required here.
}
\examples{
set.seed(1)
n <- 300
p <- 2
theta_1 <- matrix(c(-0.3, 0.6, -0.5, 0.4, 0.2, 0.2, 0.2, -0.2), nrow = p)
theta_2 <- matrix(c(0.3, -0.4, 0.1, -0.5, -0.5, -0.2, -0.5, 0.2), nrow = p)
x <- matrix(0, n + 2, p)
for (i in 1:200) {
  x[i + 2, ] <- theta_1 \%*\% c(x[i + 1, ], x[i, ]) + rnorm(p, 0, 1)
}
for (i in 201:n) {
  x[i + 2, ] <- theta_2 \%*\% c(x[i + 1, ], x[i, ]) + rnorm(p, 0, 1)
}
result <- fastcpd.var(x, 2)
summary(result)
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
