% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idi.R
\name{idi}
\alias{idi}
\alias{idi.lrm}
\alias{idi.cph}
\alias{idi.coxph}
\title{Perform IDI for logistic and cox regression}
\usage{
idi(f1, f2, ...)

\method{idi}{lrm}(f1, f2, ...)

\method{idi}{cph}(f1, f2, timepoint = NULL, ...)

\method{idi}{coxph}(f1, f2, timepoint = NULL, ...)
}
\arguments{
\item{f1}{base model}

\item{f2}{the other model}

\item{...}{ignore}

\item{timepoint}{one time point for cox regression, default is median time.}
}
\value{
IDI results
}
\description{
Easy to perform integrated discrimination improvement
    index (IDI) for logistic and cox regression.
}
\examples{
library(rms)
# logistic

data(lung)

lung$status=lung$status-1
f1=lrm(status~age+sex,lung)
f2=lrm(status~age+sex+ph.ecog,lung)
idi(f1,f2)

# survival

head(lung)

range(lung$time)

lung=lung[complete.cases(lung),]

f1=cph(Surv(time,status)~age+sex,lung)
f2=cph(Surv(time,status)~age+sex+ph.ecog,lung)
idi(f1,f2)
}
