/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MathException
extends Exception {
    private static final long serialVersionUID = -8602234299177097102L;
    private static final boolean JDK_SUPPORTS_NESTED;
    private static ResourceBundle cachedResources;
    private final String pattern;
    private final Object[] arguments;
    private final Throwable rootCause;
    static /* synthetic */ Class class$java$lang$Throwable;

    private static String translate(String s, Locale locale) {
        try {
            if (cachedResources == null || !cachedResources.getLocale().equals(locale)) {
                cachedResources = ResourceBundle.getBundle("org.apache.commons.math.MessagesResources", locale);
            }
            if (cachedResources.getLocale().getLanguage().equals(locale.getLanguage())) {
                return cachedResources.getString(s);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return s;
    }

    private static String buildMessage(String pattern, Object[] arguments, Locale locale) {
        MessageFormat mf = new MessageFormat(MathException.translate(pattern, locale));
        mf.setLocale(locale);
        return mf.format(arguments);
    }

    public MathException() {
        this.pattern = null;
        this.arguments = new Object[0];
        this.rootCause = null;
    }

    public MathException(String msg) {
        super(msg);
        this.pattern = msg;
        this.arguments = new Object[0];
        this.rootCause = null;
    }

    public MathException(String pattern, Object[] arguments) {
        super(MathException.buildMessage(pattern, arguments, Locale.US));
        this.pattern = pattern;
        this.arguments = (Object[])arguments.clone();
        this.rootCause = null;
    }

    public MathException(Throwable rootCause) {
        super(rootCause == null ? null : rootCause.getMessage());
        this.pattern = this.getMessage();
        this.arguments = new Object[0];
        this.rootCause = rootCause;
    }

    public MathException(String msg, Throwable rootCause) {
        super(msg);
        this.pattern = msg;
        this.arguments = new Object[0];
        this.rootCause = rootCause;
    }

    public MathException(String pattern, Object[] arguments, Throwable rootCause) {
        super(MathException.buildMessage(pattern, arguments, Locale.US));
        this.pattern = pattern;
        this.arguments = (Object[])arguments.clone();
        this.rootCause = rootCause;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public String getMessage(Locale locale) {
        return this.pattern == null ? null : MathException.buildMessage(this.pattern, this.arguments, locale);
    }

    public Throwable getCause() {
        return this.rootCause;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            super.printStackTrace(out);
            if (this.rootCause != null && !JDK_SUPPORTS_NESTED) {
                out.print("Caused by: ");
                this.rootCause.printStackTrace(out);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        boolean flag = false;
        try {
            (class$java$lang$Throwable == null ? (class$java$lang$Throwable = MathException.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredMethod("getCause", new Class[0]);
            flag = true;
        }
        catch (NoSuchMethodException ex) {
            flag = false;
        }
        JDK_SUPPORTS_NESTED = flag;
        cachedResources = null;
    }
}

