% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{check_archive}
\alias{check_archive}
\title{Check a Package Archive}
\usage{
check_archive(path, cmdargs = NULL)
}
\arguments{
\item{path}{Path to the package archive.}

\item{cmdargs}{Command line arguments (see
\code{\link[callr:rcmd]{callr::rcmd}})}
}
\value{
A list with the standard output, standard error
and exit status of the check.
(see \code{\link[callr:rcmd]{callr::rcmd}}).
}
\description{
This is a wrapper to
\code{\link[callr:rcmd_safe]{callr::rcmd_safe}("check")},
similar to, but leaner than
\code{\link[rcmdcheck:rcmdcheck]{rcmdcheck::rcmdcheck}}. While
the latter parses the output of \code{rcmd_safe} and uses
\pkg{clisymbols} in the callback, we here just return bare output and use
\code{\link{writeLines}} as callback. This should result in a screen display
that should be identical to the output of \command{R CMD check}.
}
\examples{
\dontrun{
package_path <- file.path(tempdir(), "fakepack")
devtools::create(path = package_path)
file.copy(system.file("templates", "throw.R", package = "fakemake"),
          file.path(package_path, "R"))
roxygen2::roxygenize(package_path)
print(tarball <- get_pkg_archive_path(package_path))
devtools::build(pkg = package_path, path = package_path)
print(check_archive(tarball))
}
}
