% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairness_pca.R
\name{fairness_pca}
\alias{fairness_pca}
\title{Fairness PCA}
\usage{
fairness_pca(x, omit_models_with_NA = FALSE)
}
\arguments{
\item{x}{object of class \code{fairness object}}

\item{omit_models_with_NA}{logical, if \code{TRUE} omits rows in \code{metric_matrix}, else omits columns (default)}
}
\value{
\code{fairness_pca} object
It is list containing following fields:
\itemize{
\item{pc_1_2}{ - amount of data variance explained with each component}
\item{rotation}{ - rotation from \code{stats::prcomp}}
\item{x}{ - x from \code{stats::prcomp}}
\item{sdev}{ - sdev from \code{stats::prcomp}}
\item{label}{ - model labels}
}
}
\description{
Calculate PC for metric_matrix to see similarities between models and metrics. If \code{omit_models_with_NA} is set to \code{TRUE} models with NA will be omitted as opposed
to default behavior, when metrics are omitted.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200,
                           num.threads = 1)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

 # same explainers with different cutoffs for female
fobject <- fairness_check(explainer_lm, explainer_rf, fobject,
                          protected = german$Sex,
                          privileged = "male",
                          cutoff = list( female = 0.4),
                          label = c("lm_2", "rf_2"))

fpca <- fairness_pca(fobject)

plot(fpca)


}
