% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{graphModel}
\alias{graphModel}
\title{Obtaining the graphical causal model (GCM)}
\usage{
graphModel(adj.mat, cfd.mat = NULL, res.vars = NULL)
}
\arguments{
\item{adj.mat}{Matrix of class \code{matrix} encoding the relationships in
the causal graph. \code{M[i,j] == 1L} implies the existence of an edge from
node i to node j.}

\item{cfd.mat}{Symmetric matrix of class \code{matrix} encoding the
bidirected edges in the causal graph. \code{M[i,j] == M[j, i] == 1L}
implies the existence of a bidirected edge between nodes i and j.}

\item{res.vars}{A vector of class \code{character} listing all the resolving
variables, which should not be changed by the adaption procedure. Default
value is \code{NULL}, corresponding to no resolving variables. Resolving
variables should be a subset of \code{colnames(adj.mat)}. Resolving
variables are marked with a different color in the output.}
}
\value{
An object of class \code{igraph}, containing the causal graphical,
with directed and bidirected edges.
}
\description{
Obtaining the graphical causal model (GCM)
}
\examples{
adj.mat <- cfd.mat <- array(0L, dim = c(3, 3))
colnames(adj.mat) <- rownames(adj.mat) <-
  colnames(cfd.mat) <- rownames(cfd.mat) <- c("A", "X", "Y")

adj.mat["A", "X"] <- adj.mat["X", "Y"] <-
  cfd.mat["X", "Y"] <- cfd.mat["Y", "X"] <- 1L

gcm <- graphModel(adj.mat, cfd.mat, res.vars = "X")

}
