% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{comtimeplot}
\alias{comtimeplot}
\title{Plot comunalities over time.}
\usage{
comtimeplot(
  x,
  fsvsimobj = NULL,
  show = "series",
  maxrows = 5,
  ylim = c(0, 100)
)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{fsvsimobj}{Object of class \code{'fsvsim'} (or \code{NULL}), usually
resulting from a call to \code{\link{fsvsim}}. Defaults to \code{NULL}.}

\item{show}{Indicator whether to show joint (\code{'joint'}), series-specific
(\code{'series'}), or both (\code{'both'}) communalities.}

\item{maxrows}{Single positive integer denoting the maximum number of series
in each plot. Defaults to 5.}

\item{ylim}{Vector of length two denoting the range of the horizontal axis.
Defaults to 1.}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{comtimeplot} plots the communalities over time, i.e. the
series-specific percentage of variance explained through the common factors.
}
\details{
This function displays the joint (average) communalities over time and all
series-specific communalities. If communalities haven't been stored during
sampling, \code{comtimeplot} produces an error.
}
\seealso{
Other plotting: 
\code{\link{corimageplot}()},
\code{\link{corplot}()},
\code{\link{cortimeplot}()},
\code{\link{evdiag}()},
\code{\link{facloadcredplot}()},
\code{\link{facloaddensplot}()},
\code{\link{facloadpairplot}()},
\code{\link{facloadpointplot}()},
\code{\link{facloadtraceplot}()},
\code{\link{logvartimeplot}()},
\code{\link{paratraceplot}()},
\code{\link{plot.fsvdraws}()},
\code{\link{plotalot}()},
\code{\link{voltimeplot}()}
}
\concept{plotting}
