% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create.parameters}
\alias{create.parameters}
\title{Create Parameters}
\usage{
create.parameters(Ds, Gs, Rs, dispersal, radius, stress, n)
}
\arguments{
\item{Ds}{An array of death rates for the structured population, of length \code{n}}

\item{Gs}{An array of growth rates for the structured population, of length \code{n-1}}

\item{Rs}{Either the seed production rate of adults in the population, or an array of seed production rates, of length \code{n}.}

\item{dispersal}{Dispersal distances}

\item{radius}{Optional (use if there are any interactions). Either one radius of
interactions or an array of interaction radiuses, of length \code{n}.}

\item{stress}{Optional (use to create a stress gradient). An array of
values of stress gradient slope. The full value will be added to death rate at the right
of the plot, half value at the middle of the plot, and so on, proportionally.}

\item{n}{Number of stages in the population}
}
\description{
Structures the parameters into the correct format for use in  \link{community}
}
\examples{
# create a sample parameters
create.parameters(n=3)

# structure parameters from arrays
create.parameters(Ds=c(10,5,2),Gs=c(2,2),Rs=20,radius=2)

}
