% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FacebookMessagesCollection.R
\name{FacebookMessagesCollection}
\alias{FacebookMessagesCollection}
\title{Build a collection of Facebook inbox messages}
\usage{
FacebookMessagesCollection(id, token = NULL, parameters = list(),
  fields = c("id", "from", "created_time", "message"),
  n = getOption("facebook.maxitems"), metadata = FALSE,
  .progress = create_progress_bar())
}
\arguments{
\item{id}{A character vector or a comma-delimited string of IDs or an existing Facebook Collection of any 
of the supported types (see below).}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{\link{fbOAuth}}. If token \code{NULL} and \code{id} is a collection,
use the token of the source collection. Otherwise, no query is performed
to the Facebook Graph API and an empty collection is returned.}

\item{parameters}{A list of parameters to be added to the Facebook Graph API query. For more information on the
accepted parameters, see: \url{https://developers.facebook.com/docs/graph-api/using-graph-api}.}

\item{fields}{A character vector with the fields to get for each \code{id}. If no value
for a given field is found, it will be set to \code{NULL}.}

\item{n}{If \code{id} is an iterable collection, then \code{n} is the maximum number of conversations to be pulled for each element of the source collection
in \code{id}. It can be set to \code{Inf} to pull out any available conversation and assumes the default value from the value
of \code{facebook.maxitems} global option if missing. If \code{id} is not a collection or cannot be iterated, the parameter is ignored.}

\item{metadata}{If set to \code{TRUE}, the metadata for each ID is pulled with the data
and the \code{type} slot is fed accordingly.
Please note that setting this to \code{TRUE} could considerably
slow down the execution time, as more queries are needed.}

\item{.progress}{progress_bar object as defined in the plyr package.
By default the \code{none} progress bar is used, which prints nothing to the console. See \link[plyr]{create_progress_bar} for details.}
}
\value{
A collection of messages in a \code{\link{FacebookMessagesCollection-class}} object.
}
\description{
Connect to Facebook Graph API, get information from a list of inbox messages and build a \code{\link{FacebookMessagesCollection-class}}
instance.
}
\details{
\code{FacebookMessagesCollection} is the constructor for the \code{\link{FacebookMessagesCollection-class}}.
It returns data about inbox messages between users or users and pages.
}
\section{Valid sources}{

Instead of a character vector, one of these collections can also be passed as parameter in \code{id}:
\itemize{
 \item{\code{\link{FacebookConversationsCollection-class}} will build a collection with 
 all the messages from the given conversations. A page access token with \code{read_page_mailboxes} is needed
 to read the related mailboxes user access token with \code{read_mailbox} is needed to perform this action,
 in case of conversations between users.}
}
}

\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
 load("fb_page_oauth")
 
## Getting the messages of the first conversation of an example page.
## A page access token is needed to access the inbox
 messages <- FacebookPagesCollection("9thcirclegames", fb_page_oauth) \%>\%
             FacebookConversationsCollection(n = 1) \%>\%
             FacebookMessagesCollection()
}

}
\seealso{
\code{\link{FacebookConversationsCollection}}, \code{\link{facebook.participants}}, \code{\link{facebook.senders}}

Other Facebook Collection Constructors: \code{\link{FacebookAlbumsCollection}},
  \code{\link{FacebookCommentsCollection}},
  \code{\link{FacebookConversationsCollection}},
  \code{\link{FacebookEventsCollection}},
  \code{\link{FacebookGroupsCollection}},
  \code{\link{FacebookLikesCollection}},
  \code{\link{FacebookPagesCollection}},
  \code{\link{FacebookPhotosCollection}},
  \code{\link{FacebookPostsCollection}},
  \code{\link{FacebookReactionsCollection}},
  \code{\link{FacebookUsersCollection}},
  \code{\link{FacebookVideosCollection}}
}
\author{
Gabriele Baldassarre \url{https://gabrielebaldassarre.com}
}
