% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potential_outcomes.R
\name{potential_outcomes}
\alias{potential_outcomes}
\title{Build potential outcomes variables}
\usage{
potential_outcomes(x, conditions = list(Z = c(0, 1)), sep = "_")
}
\arguments{
\item{x}{Formula describing the potential outcomes with the outcome name on the left hand side and the expression describing the potential outcomes on the right hand side, e.g. \code{Y ~ 0.1 * Z + rnorm(N)} (this would draw two potential outcomes columns by default, named Y_Z_0 and Y_Z_1).}

\item{conditions}{A list of conditions for each assignment variable. Defaults to \code{list(Z = c(0, 1))}.}

\item{sep}{Separator inserted between the outcome name and the assignment variable name used to construct the potential outcome variable names, defaults to "_".}
}
\description{
Function to draw multiple potential outcomes, one for each condition that an assignment variable can be set to.
}
\examples{

fabricate(
  N = 10,
  U = rnorm(N),
  potential_outcomes(Y ~ 0.1 * Z + U)
)

# equivalently,

fabricate(
  N = 10,
  U = rnorm(N),
  potential_outcomes(Y ~ 0.1 * Z + U,
                     conditions = list(Z = c(0, 1)))
)

fabricate(
  N = 10,
  U = rnorm(N),
  potential_outcomes(Y ~ 0.1 * Z + U,
                     conditions = list(Z = c(1, 2, 3)))
)

fabricate(
  N = 10,
  U = rnorm(N),
  potential_outcomes(Y ~ 0.1 * Z1 + 0.3 * Z2 + 0.5 * Z1 * Z2 + U,
                     conditions = list(Z1 = c(0, 1),
                                       Z2 = c(0, 1)))
)


}
