% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{generate.ARIMA}
\alias{generate.ARIMA}
\title{Generate new data from a fable model}
\usage{
\method{generate}{ARIMA}(x, new_data, specials, bootstrap = FALSE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{new_data}{A \code{tsibble} containing future information used to forecast.}

\item{specials}{(passed by \code{\link[fabletools:forecast.mdl_df]{fabletools::forecast.mdl_df()}}).}

\item{bootstrap}{If \code{TRUE}, then forecast distributions are computed using simulation with resampled errors.}

\item{...}{Additional arguments for forecast model methods.}
}
\description{
Simulates future paths from a dataset using a fitted model. Innovations are
sampled by the model's assumed error distribution. If \code{bootstrap} is \code{TRUE},
innovations will be sampled from the model's residuals. If \code{new_data}
contains the \code{.innov} column, those values will be treated as innovations.
}
\examples{
fable_fit <- as_tsibble(USAccDeaths) \%>\%
  model(model = ARIMA(value ~ 0 + pdq(0,1,1) + PDQ(0,1,1)))
fable_fit \%>\% generate(times = 10)

}
\seealso{
\code{\link[fabletools:generate.mdl_df]{fabletools::generate.mdl_df}}
}
