% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_specials.R
\docType{data}
\name{common_xregs}
\alias{common_xregs}
\title{Common exogenous regressors}
\usage{
common_xregs
}
\description{
These special functions provide interfaces to more complicated functions within
the model formulae interface.
}
\section{Specials}{


\subsection{trend}{
The \code{trend} special includes common linear trend regressors in the model. It also supports piecewise linear trend via the \code{knots} argument.
\preformatted{
trend(knots = NULL, origin = NULL)
}

\tabular{ll}{
\code{knots}    \tab A vector of times (same class as the data's time index) identifying the position of knots for a piecewise linear trend.\cr
\code{origin}   \tab An optional time value to act as the starting time for the trend.
}
}

\subsection{season}{
The \code{season} special includes seasonal dummy variables in the model.
\preformatted{
season(period = NULL)
}

\tabular{ll}{
\code{period}   \tab The periodic nature of the seasonality. This can be either a number indicating the number of observations in each seasonal period, or text to indicate the duration of the seasonal window (for example, annual seasonality would be "1 year").
}
}

\subsection{fourier}{
The \code{fourier} special includes seasonal fourier terms in the model. The maximum order of the fourier terms must be specified using \code{K}.
\preformatted{
fourier(period = NULL, K, origin = NULL)
}

\tabular{ll}{
\code{period}   \tab The periodic nature of the seasonality. This can be either a number indicating the number of observations in each seasonal period, or text to indicate the duration of the seasonal window (for example, annual seasonality would be "1 year"). \cr
\code{K}        \tab The maximum order of the fourier terms.\cr
\code{origin}   \tab An optional time value to act as the starting time for the fourier series.
}
}
}

\keyword{datasets}
