% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/close_to_lreturn.R
\name{close_to_lreturn}
\alias{close_to_lreturn}
\title{Log-Return Calculation From Closing Prices}
\usage{
close_to_lreturn(close)
}
\arguments{
\item{close}{a closing price series as a numeric vector or some time series object
like \code{"ts"} or \code{"zoo"} ordered chronologically.}
}
\value{
Returns the log-return series following the input \code{close}. The output object
has one observation less than \code{close}, but keeps potential time series
formatting.
}
\description{
Makes log-returns available from an input closing price series.
}
\details{
Let \eqn{P_t}, \eqn{t=1^,\dots,n}, be an observed closing price series. The function
returns
\deqn{r_t = \ln{P_t}-\ln{P_{t-1}}},  t = 2,\dots,n.
}
\examples{
# Assume SP500 + 100 was a closing price series,
# which it is not
close <- SP500 + 100
close_to_lreturn(close)

}
