% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_plot.R
\name{pr_plot}
\alias{pr_plot}
\title{pr_plot}
\usage{
pr_plot(
  data,
  actual,
  fitted,
  group = NULL,
  facet_x = NULL,
  facet_y = NULL,
  size_line = 1,
  size = 11,
  labs = "short",
  env = parent.frame()
)
}
\arguments{
\item{data}{A data.frame.}

\item{actual}{Vector of actuals values}

\item{fitted}{Vector of fitted values}

\item{group}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{size_line}{width of line for \code{geom_line()}. Default is 1.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{labs}{'short' or 'long'}

\item{env}{environment for evaluating expressions.}
}
\description{
precision-recall plot
}
\examples{
library(ggplot2)
n = 1000
df = data.frame(actual = sample(c(FALSE, TRUE), n, replace = TRUE),
                runif = runif(n))
df[["fitted"]] = runif(n) ^ ifelse(df[["actual"]] == 1, 0.5, 2)

ggplot(df) +
  geom_density(aes(fitted, fill = actual), alpha = 0.5)

pr_plot(df, "actual", "fitted")
pr_plot(df, "actual", "runif", size_line = 0.5)

\donttest{
library(dplyr, warn.conflicts = FALSE)
pr_plot(df, "actual", "fitted", "sample(c(1, 2), n(), TRUE)")

pr_plot(df, "actual", "fitted",
        "sample(c(1, 2), n(), TRUE)",
        "sample(c(3, 4), n(), TRUE)")

pr_plot(df, "actual", "fitted",
        "sample(c(1, 2), n(), TRUE)",
        "sample(c(3, 4), n(), TRUE)",
        "sample(c(5, 6), n(), TRUE)")
}
}
