% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_models.R
\name{get_models}
\alias{get_models}
\title{Get Model List from ezcox Object}
\usage{
get_models(x, variables = NULL)
}
\arguments{
\item{x}{a \code{ezcox} object from \code{\link[=ezcox]{ezcox()}}.}

\item{variables}{a character vector representing variables to select.}
}
\value{
a named \code{list} with class \code{ezcox_models}
}
\description{
Models are renamed by the formulas.
}
\examples{
library(survival)
zz <- ezcox(lung, covariates = c("sex", "ph.ecog"), controls = "age", return_models = TRUE)
mds <- get_models(zz)
str(mds, max.level = 1)
}
