% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot heatmap of raw data}
\usage{
plot_heatmap(
  data = NULL,
  trial_number = NULL,
  bg_image = NULL,
  res = c(0, 1920, 0, 1080),
  flip_y = FALSE,
  alpha_control = 0.1,
  plot_header = FALSE
)
}
\arguments{
\item{data}{data in standard raw data form (time, x, y, trial)}

\item{trial_number}{can be used to select particular trials within the data}

\item{bg_image}{The filepath of an image to be added to the plot, for example to show a screenshot of the task.}

\item{res}{resolution of the display to be shown, as a vector (xmin, xmax, ymin, ymax)}

\item{flip_y}{reverse the y axis coordinates (useful if origin is top of the screen)}

\item{alpha_control}{a single value to determine how much of the heatmap to obscure. Between 0 and 1. Lower values include more data in the heatmap}

\item{plot_header}{display the header title text which explains graphical features of the plot.}
}
\value{
a plot of the raw data
}
\description{
Plots a heatmap of raw data.
}
\examples{
\donttest{
data <- combine_eyes(HCL)
data <- data[data$pNum == 118,]
# plot all trials data
plot_heatmap(data, alpha_control = .01)

#plot one trial
plot_heatmap(data, trial_number = 1)

}
}
