% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_exvadir.R
\name{make_exvadir}
\alias{make_exvadir}
\title{Direction (detailed  origin and destination) of value added in exports}
\usage{
make_exvadir(
  wio_object,
  exporter,
  va_type = "TC",
  flow_type = "EXGR",
  orig_geo = "all",
  sec_orig = "all",
  via = "any",
  perspective = "exporter",
  intra = FALSE
)
}
\arguments{
\item{wio_object}{A \code{wio} object}

\item{exporter}{Country code (or country group code) of exporting country}

\item{va_type}{VA total content (\code{"TC"}), domestic (\code{"DC"}) or foreign
content (\code{"FC"}) or VA content excluding double counting
(\code{"TVA"}, \code{"DVA"}, \code{"FVA"})}

\item{flow_type}{Gross exports (\code{"EXGR"}) or in terms of final demand:
\code{"EXGRY"}, \code{"EXGRY_FIN"}, \code{"EXGRY_INT"}.}

\item{orig_geo}{Geographical origin of value added (default: \code{"all"})}

\item{sec_orig}{Code of sector of origin of value added (default: \code{"all"})}

\item{via}{Code of intermediate importing country (default: \code{"any"})}

\item{perspective}{Sector perspective, \code{"origin"} or \code{"exporter"}.}

\item{intra}{Boolean for inclusion of intra-regional exports
(default: \code{FALSE})}
}
\value{
Matrix with source and destination of value added in exports
}
\description{
Direction of value added in exports, i.e., details of both
geographical and sector origin of the VA incorporated in exports and
of the final destination (in gross terms or in terms of final absorption).
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
# Foreign services content of value added incorporated in exports of Spain,
# by country of origin and final destination, expressed in gross terms
# (equivalent to OECD TiVA’s indicator EXGR_SERV_FVA).
exvadir <- make_exvadir(wio, va = "FC", flow="EXGR", exp="ESP",
                        sec_orig="SRVWC")
summary(exvadir)
}
