% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_credibility.r
\name{add_credibility}
\alias{add_credibility}
\title{Add Credibility Factors}
\usage{
add_credibility(
  expstudy,
  .cred_k = 0.05,
  .cred_p = 0.95,
  .cred_nms = "CREDIBILITY"
)
}
\arguments{
\item{expstudy}{an \code{\link[=expstudy]{expstudy}}}

\item{.cred_k}{number within range (0, 1); range parameter of credibility equation}

\item{.cred_p}{number within range (0, 1); probability parameter of credibility equation}

\item{.cred_nms}{character vector of column names for the added credibility column. If more
than one credibility column will be created, you can distinguish them here.}
}
\value{
An \code{expstudy} with added credibility factors.
}
\description{
Add credibility factors for an \code{expstudy}'s \code{expecteds} metric variable.
The credibility calculation uses a classical credibility approach
also known as limited fluctuation partial credibility. Under this approach,
the credibility factor is calculated so that \code{actuals} are within \eqn{k}\\%
of \code{expecteds} with probability \eqn{p}.

Credibility range parameter \eqn{k} and probability level \eqn{p} are set
using the function arguments \code{.cred_k} and \code{.cred_p}, respectively.
}
\examples{
  es <- expstudy(
    data = mortexp,
    actuals = ACTUAL_DEATHS,
    expecteds = EXPECTED_DEATHS,
    exposures =  EXPOSURE,
    variances = VARIANCE_DEATHS
  )

   es \%>\%
     aggregate(ATTAINED_AGE) \%>\%
     add_credibility

   es \%>\%
     aggregate(
       UNDERWRITING_CLASS,
       GENDER,
       SMOKING_STATUS
     ) \%>\%
     add_credibility

}
