% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category.R
\name{category}
\alias{category}
\alias{category_df}
\title{Convert dichotomy matrix/data.frame to matrix/data.frame with category encoding}
\usage{
category(x, prefix = NULL, use_var_lab = TRUE, counted_value = 1,
  compress = TRUE)

category_df(x, prefix = NULL, use_var_lab = TRUE, counted_value = 1,
  compress = TRUE)
}
\arguments{
\item{x}{Dichotomy matrix (usually with 0,1 coding).}

\item{prefix}{If not is NULL then column names will be added in the form
prefix+column number.}

\item{use_var_lab}{logical If TRUE then we will try to use variable labels as
value labels instead of column names.}

\item{counted_value}{Vector. Values that should be considered as indicator 
of category presence. By default it equals to 1.}

\item{compress}{Logical. Should we drop columns with all NA?}
}
\value{
Matrix or data.frame with numeric values that correspond to column
  numbers of counted values. Column names of x or variable labels are added as value labels.
}
\description{
Convert dichotomy matrix/data.frame to matrix/data.frame with category encoding
}
\examples{
set.seed(123)

# Let's imagine it's matrix of consumed products
dichotomy_matrix = matrix(sample(0:1,40,replace = TRUE,prob=c(.6,.4)),nrow=10)
colnames(dichotomy_matrix) = c("Milk","Sugar","Tea","Coffee")
category(dichotomy_matrix,compress=FALSE) # uncompressed version
category_matrix=category(dichotomy_matrix)

 # should be TRUE
identical(val_lab(category_matrix),c(Milk = 1L,Sugar = 2L,Tea = 3L,Coffee = 4L))
all(dichotomy(category_matrix,use_na = FALSE)==dichotomy_matrix)

# with prefix
category(dichotomy_matrix, prefix = "products_")

# data.frame with variable labels
dichotomy_dataframe = as.data.frame(dichotomy_matrix)
colnames(dichotomy_dataframe) = paste0("product_", 1:4)
var_lab(dichotomy_dataframe[[1]]) = "Milk"
var_lab(dichotomy_dataframe[[2]]) = "Sugar"
var_lab(dichotomy_dataframe[[3]]) = "Tea"
var_lab(dichotomy_dataframe[[4]]) = "Coffee"

category_df(dichotomy_dataframe, prefix = "products_")

}
\seealso{
\code{\link{dichotomy}} for reverse conversion.
}

