% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{inspect}
\alias{inspect}
\title{Inspect the index}
\usage{
inspect(i, pheno, omit = NULL, index_name = "batch")
}
\arguments{
\item{i}{List of indices of samples per batch}

\item{pheno}{Data.frame with the sample information.}

\item{omit}{Name of the columns of the \code{pheno} that will be omitted.}

\item{index_name}{Column name of the index of the resulting data.frame.}
}
\value{
The data.frame with a new column batch with the name of the batch the sample goes to.
}
\description{
Given the index and the data of the samples append the batch assignment
}
\examples{
data(survey, package = "MASS")
columns <- c("Sex", "Age", "Smoke")
index <- design(pheno = survey[, columns], size_subset = 70,
                iterations = 10)
batches <- inspect(index, survey[, columns])
head(batches)
}
