% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate_orig}
\alias{evaluate_orig}
\title{Evaluate each variable provided}
\usage{
evaluate_orig(pheno)
}
\arguments{
\item{pheno}{Data.frame with information about the samples}
}
\value{
A matrix with the mean, standard deviation, MAD values of the
numeric variables, the entropy of the categorical, and the amount of
\code{NA} per variable.
}
\description{
Measure some summary statistics of the whole cohort of samples
}
\examples{
data(survey, package = "MASS")
evaluate_orig(survey[, c("Sex", "Age", "Smoke")])
}
\seealso{
Other functions to evaluate samples: 
\code{\link{evaluate_entropy}()},
\code{\link{evaluate_independence}()},
\code{\link{evaluate_index}()},
\code{\link{evaluate_mad}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_na}()},
\code{\link{evaluate_sd}()}
}
\concept{functions to evaluate samples}
