/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class Common {
    public static final String JAVAOBJECT_SUFFIX = ".java.object";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PICARD_JARDIR = "/home/noemi/workspace/NGS_Picard/lib/picard-tools-1.79/";
    public static final String GENOMEANALYSISTK_JAR = "/home/share/Tools/GenomeAnalysisTK-2.2-14-g11728e9/GenomeAnalysisTK.jar";
    public static final Map<String, String> KNOWNSITES = new HashMap<String, String>();
    public static final String VARSCANJAR = "/home/share/Tools/VarScan/VarScan.v2.3.4.jar";
    public static final String MUTECTJAR = "/home/share/Tools/MuTect/muTect-1.1.4.jar";
    public static final String FEATURE_SEPARATOR = "------";

    static {
        String vcf = "dbsnp_137.hg19.vcf";
        KNOWNSITES.put(vcf, "/home/share/data/dbSNP/" + vcf);
    }

    public static boolean isDouble(String string) {
        try {
            Double.valueOf(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String string) {
        try {
            Long.valueOf(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInt(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean equals(Map m1, Map m2) {
        if (!m1.keySet().containsAll(m2.keySet()) || !m2.keySet().containsAll(m1.keySet())) {
            return false;
        }
        for (Object key : m1.keySet()) {
            if (m1.get(key).equals(m2.get(key))) continue;
            return false;
        }
        return true;
    }

    public static Integer[] isNotNa(double[] array) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (!Double.isNaN(array[i])) {
                l.add(i);
            }
            ++i;
        }
        return l.toArray(new Integer[l.size()]);
    }

    public static double[] getNotNa(double[] array) {
        Integer[] indices = Common.isNotNa(array);
        double[] newA = new double[indices.length];
        int i = 0;
        while (i < indices.length) {
            newA[i] = array[indices[i]];
            ++i;
        }
        return newA;
    }

    public static Integer[] isEqualTo(double[] array, double d) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i] == d) {
                l.add(i);
            }
            ++i;
        }
        return l.toArray(new Integer[l.size()]);
    }

    public static void wait(int n) {
        long t1;
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < 1000L) {
        }
    }

    public static Map<String, double[][]> removeEntries(Map<String, double[]> in, int size, int startX) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            for (String g : in.keySet()) {
                if (!Double.isNaN(in.get(g)[i])) continue;
                toRemove.add(i);
                break;
            }
            ++i;
        }
        HashMap<String, double[][]> newMap = new HashMap<String, double[][]>();
        for (String s : in.keySet()) {
            newMap.put(s, new double[2][size - toRemove.size()]);
            int pos = 0;
            int i2 = 0;
            while (i2 < size) {
                if (!toRemove.contains(i2)) {
                    ((double[][])newMap.get((Object)s))[1][pos] = in.get(s)[i2];
                    ((double[][])newMap.get((Object)s))[0][pos] = startX + pos;
                    ++pos;
                }
                ++i2;
            }
        }
        return newMap;
    }

    public static double[] fillArray(int startNo, int stopNo) {
        double[] a = new double[stopNo - startNo];
        int i = startNo;
        while (i < stopNo) {
            a[i - startNo] = i;
            ++i;
        }
        return a;
    }

    public static double[] fillArray(int length, double numberVal) {
        double[] a = new double[length];
        int i = 0;
        while (i < a.length) {
            a[i] = numberVal;
            ++i;
        }
        return a;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double setDecimalState(double d, int n) {
        int x = 1;
        while (n > 0) {
            x *= 10;
            --n;
        }
        return (double)((int)(d * (double)x)) / (double)x;
    }

    public static <T extends Collection> T merge(Collection<T> collections) {
        Iterator<T> iter = collections.iterator();
        Collection merged = (Collection)iter.next();
        while (iter.hasNext()) {
            merged.addAll((Collection)iter.next());
        }
        return (T)merged;
    }

    public static <N extends Number> double[] toArray(List<N> l) {
        double[] a = new double[l.size()];
        int pos = 0;
        for (Number d : l) {
            a[pos] = d.doubleValue();
            ++pos;
        }
        return a;
    }

    public static <T> String toString(List<T> list, String sep) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < list.size() - 1) {
            b.append(String.valueOf(list.get(i).toString()) + sep);
            ++i;
        }
        b.append(list.get(i).toString());
        return b.toString();
    }

    public static String toString(float[] newData, String sep) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < newData.length - 1) {
            b.append(String.valueOf(newData[i]) + sep);
            ++i;
        }
        b.append(newData[i]);
        return b.toString();
    }

    public static <T> String toString(Collection<T> list, String sep) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        Iterator<T> iter = list.iterator();
        while (i < list.size() - 1) {
            b.append(String.valueOf(iter.next().toString()) + sep);
            ++i;
        }
        b.append(iter.next().toString());
        return b.toString();
    }

    public static String toString(double[] d2, String sep) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < d2.length - 1) {
            b.append(String.valueOf(Common.setDecimalState(d2[i], 2)) + sep);
            ++i;
        }
        b.append(Common.setDecimalState(d2[i], 2));
        return b.toString();
    }

    public static String toString(int[] d2, String sep) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < d2.length - 1) {
            b.append(String.valueOf(d2[i]) + sep);
            ++i;
        }
        b.append(d2[i]);
        return b.toString();
    }

    public static String toString(byte[] d2, String sep) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < d2.length - 1) {
            b.append(String.valueOf(d2[i]) + sep);
            ++i;
        }
        b.append(d2[i]);
        return b.toString();
    }

    public static String toString(int[] d2) {
        StringBuffer b = new StringBuffer();
        int[] nArray = d2;
        int n = d2.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            b.append(String.valueOf(d) + "\t");
            ++n2;
        }
        return b.toString();
    }

    public static double[] getValues(double[] d1, Integer[] indices) {
        double[] res = new double[indices.length];
        int i = 0;
        while (i < indices.length) {
            res[i] = d1[indices[i]];
            ++i;
        }
        return res;
    }

    public static double getPearsonCorrelation(double[] scores1, double[] scores2) {
        Integer[] indices = Common.isNotNa(scores1);
        indices = Common.intersect(indices, Common.isNotNa(scores2));
        scores1 = Common.getValues(scores1, indices);
        scores2 = Common.getValues(scores2, indices);
        double result = 0.0;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        double mean_x = scores1[0];
        double mean_y = scores2[0];
        int i = 2;
        while (i < scores1.length + 1) {
            double sweep = Double.valueOf(i - 1) / (double)i;
            double delta_x = scores1[i - 1] - mean_x;
            double delta_y = scores2[i - 1] - mean_y;
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (double)i;
            mean_y += delta_y / (double)i;
            ++i;
        }
        double pop_sd_x = Math.sqrt(sum_sq_x / (double)scores1.length);
        double pop_sd_y = Math.sqrt(sum_sq_y / (double)scores1.length);
        double cov_x_y = sum_coproduct / (double)scores1.length;
        result = cov_x_y / (pop_sd_x * pop_sd_y);
        return result;
    }

    public static double getPearsonCorrelation(List<Double> scores1, List<Double> scores2) {
        double result = 0.0;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        double mean_x = scores1.get(0);
        double mean_y = scores2.get(0);
        int i = 2;
        while (i < scores1.size() + 1) {
            double sweep = Double.valueOf(i - 1) / (double)i;
            double delta_x = scores1.get(i - 1) - mean_x;
            double delta_y = scores2.get(i - 1) - mean_y;
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (double)i;
            mean_y += delta_y / (double)i;
            ++i;
        }
        double pop_sd_x = Math.sqrt(sum_sq_x / (double)scores1.size());
        double pop_sd_y = Math.sqrt(sum_sq_y / (double)scores1.size());
        double cov_x_y = sum_coproduct / (double)scores1.size();
        result = cov_x_y / (pop_sd_x * pop_sd_y);
        return result;
    }

    public static Set<Integer> randUnique(int max, int count) throws Exception {
        if (max < count) {
            throw new Exception("Can't create " + count + " unique random values between 0 (inclusive) and " + max + " (exclusive)");
        }
        Random r = new Random();
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < count) {
            set.add(r.nextInt(max));
        }
        return set;
    }

    public static double[] switchOrder(double[] in) {
        double[] out = new double[in.length];
        HashSet<Integer> done = new HashSet<Integer>();
        Random r = new Random();
        int pos = 0;
        while (pos < in.length) {
            int i = r.nextInt(in.length);
            if (done.contains(i)) continue;
            done.add(i);
            out[pos] = in[i];
            ++pos;
        }
        return out;
    }

    public static <C> Object[] getSortedKeys(Map<C, Double> map) {
        ArrayList<Double> out = new ArrayList<Double>();
        for (Map.Entry<C, Double> entry : map.entrySet()) {
            out.add(entry.getValue());
        }
        Object[] sorted = out.toArray(new Double[out.size()]);
        Arrays.sort(sorted);
        Object[] res = new Object[map.size()];
        block1: for (C key : map.keySet()) {
            int i = 0;
            while (i < sorted.length) {
                if (map.get(key) == sorted[i] && res[i] == null) {
                    res[i] = key;
                    if (i != 0) continue block1;
                    System.out.println(map.get(key));
                    continue block1;
                }
                ++i;
            }
        }
        return res;
    }

    public static double mean(List<Double> nvals) {
        double mean = 0.0;
        int valid = 0;
        for (double d : nvals) {
            if (Double.isNaN(d)) continue;
            mean += d;
            ++valid;
        }
        if (valid == 0) {
            return Double.NaN;
        }
        return mean / (double)valid;
    }

    public static double mean(Double[] vals) {
        double mean = 0.0;
        int valid = 0;
        Double[] doubleArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            double d = doubleArray[n2];
            if (!Double.isNaN(d)) {
                mean += d;
                ++valid;
            }
            ++n2;
        }
        if (valid == 0) {
            return Double.NaN;
        }
        return mean / (double)valid;
    }

    public static double mean(double[] nvals) {
        Integer[] notNaN;
        double mean = 0.0;
        Integer[] integerArray = notNaN = Common.isNotNa(nvals);
        int n = notNaN.length;
        int n2 = 0;
        while (n2 < n) {
            int i = integerArray[n2];
            mean += nvals[i];
            ++n2;
        }
        if (notNaN.length == 0) {
            return Double.NaN;
        }
        return mean / (double)notNaN.length;
    }

    public static int firstIndexOf(Object o, Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(Object o, Object[] array) {
        int lastIDx = -1;
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(o)) {
                lastIDx = i;
            }
            ++i;
        }
        return lastIDx;
    }

    public static List<Double> toList(double[] value) {
        ArrayList<Double> l = new ArrayList<Double>();
        double[] dArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            l.add(d);
            ++n2;
        }
        return l;
    }

    public static <C> List<C> toList(C[] value) {
        ArrayList<C> l = new ArrayList<C>();
        C[] CArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            C d = CArray[n2];
            l.add(d);
            ++n2;
        }
        return l;
    }

    public static <C> Set<C> toSet(C[] value) {
        HashSet<C> l = new HashSet<C>();
        C[] CArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            C d = CArray[n2];
            l.add(d);
            ++n2;
        }
        return l;
    }

    public static List<Integer> toList(Integer[] value) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        Integer[] integerArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            Integer d = integerArray[n2];
            l.add(d);
            ++n2;
        }
        return l;
    }

    public static int argMax(List<Double> vals) {
        int max = 0;
        int i = 0;
        while (i < vals.size()) {
            if (vals.get(max) < vals.get(i)) {
                max = i;
            }
            ++i;
        }
        return max;
    }

    public static int max(int[] is) {
        int max = Integer.MIN_VALUE;
        int[] nArray = is;
        int n = is.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (max < i) {
                max = i;
            }
            ++n2;
        }
        return max;
    }

    public static double[] add(double[] a, double d) {
        double[] newD = new double[a.length];
        int i = 0;
        while (i < newD.length) {
            newD[i] = a[i] + d;
            ++i;
        }
        return newD;
    }

    public static double[] abs(double[] a) {
        double[] newD = new double[a.length];
        int i = 0;
        while (i < newD.length) {
            newD[i] = Math.abs(a[i]);
            ++i;
        }
        return newD;
    }

    public static Integer[] intersect(Integer[] a1, Integer[] a2) {
        ArrayList<Integer> intersection = new ArrayList<Integer>();
        List<Integer> a2List = Common.toList(a2);
        Integer[] integerArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i = integerArray[n2];
            if (a2List.contains(i)) {
                intersection.add(i);
            }
            ++n2;
        }
        return intersection.toArray(new Integer[intersection.size()]);
    }

    public static String toString(String[] d, String sep) {
        StringBuffer b = new StringBuffer();
        String[] stringArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            b.append(String.valueOf(s) + sep);
            ++n2;
        }
        return b.substring(0, b.length() - sep.length());
    }

    public static int count(String[] d, String string) {
        int nr = 0;
        String[] stringArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.contains(string)) {
                ++nr;
            }
            ++n2;
        }
        return nr;
    }

    public static <T> Map<T, Integer> hist(List<T> list) {
        HashMap<T, Integer> map = new HashMap<T, Integer>();
        for (T obj : list) {
            if (!map.containsKey(obj)) {
                map.put(obj, 0);
            }
            map.put(obj, (Integer)map.get(obj) + 1);
        }
        return map;
    }

    public static String toString(Set<String> value, String sep) {
        StringBuffer b = new StringBuffer();
        for (String s : value) {
            b.append(String.valueOf(s) + sep);
        }
        return b.substring(0, b.length() - sep.length());
    }

    public static BufferedReader getReader(String cbsin) throws FileNotFoundException {
        return new BufferedReader(new FileReader(new File(cbsin)));
    }

    public static BufferedWriter getWriter(String out) throws IOException {
        return new BufferedWriter(new FileWriter(new File(out)));
    }

    public static BufferedWriter getWriterToAppend(String out) throws IOException {
        return new BufferedWriter(new FileWriter(new File(out), true));
    }

    public static String toString(char[] ns, String sep) {
        StringBuffer b = new StringBuffer();
        char[] cArray = ns;
        int n = ns.length;
        int n2 = 0;
        while (n2 < n) {
            char s = cArray[n2];
            b.append(String.valueOf(String.valueOf(s)) + sep);
            ++n2;
        }
        return b.substring(0, b.length() - sep.length());
    }

    public static String toString(double[][] distrib, String sep) {
        String out = "";
        int i = 0;
        while (i < distrib.length) {
            int j = 0;
            while (j < distrib[i].length) {
                out = String.valueOf(out) + distrib[i][j] + sep;
                ++j;
            }
            out = out.substring(0, out.length() - sep.length());
            out = String.valueOf(out) + "\n";
            ++i;
        }
        return out;
    }

    public static double[] toDouble(String[] rs) throws NumberFormatException {
        double[] d = new double[rs.length];
        int pos = 0;
        String[] stringArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (Common.isDouble(s = s.trim())) {
                d[pos] = Double.parseDouble(s.trim());
                ++pos;
            } else {
                throw new NumberFormatException();
            }
            ++n2;
        }
        return d;
    }

    public static long[] toLong(String[] rs) throws NumberFormatException {
        long[] d = new long[rs.length];
        int pos = 0;
        String[] stringArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (Common.isLong(s = s.trim())) {
                d[pos] = Long.parseLong(s.trim());
                ++pos;
            } else {
                throw new NumberFormatException();
            }
            ++n2;
        }
        return d;
    }

    public static int[] toInt(String[] rs) {
        int[] d = new int[rs.length];
        int pos = 0;
        String[] stringArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (Common.isInteger(s)) {
                d[pos] = Integer.parseInt(s.trim());
                ++pos;
            } else {
                throw new NumberFormatException();
            }
            ++n2;
        }
        return d;
    }

    public static double[] solveQuadraticEq(double a, double b, double c) {
        double f1 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / 2.0 * a;
        double f2 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / 2.0 * a;
        return new double[]{f1, f2};
    }

    public static double[] fillArray(double[] range, int start, int[] bq) {
        double[] newlarge = range;
        int i = 0;
        while (i < bq.length) {
            range[start + i] = bq[i];
            ++i;
        }
        return newlarge;
    }

    public static byte[] equals(byte[] b1, byte[] b2) throws Exception {
        if (b1.length != b2.length) {
            throw new Exception("Input arrays must have same length");
        }
        byte[] result = new byte[b1.length];
        int i = 0;
        while (i < b1.length) {
            result[i] = b1[i] == b2[i] ? 1 : -1;
            ++i;
        }
        return result;
    }

    public static int[] multiply(byte[] b1, byte[] b2) throws Exception {
        if (b1.length != b2.length) {
            throw new Exception("Input arrays must have same length");
        }
        int[] result = new int[b1.length];
        int i = 0;
        while (i < b1.length) {
            result[i] = b1[i] * b2[i];
            ++i;
        }
        return result;
    }

    public static double[] plus(double[] ds, double d) {
        double[] res = new double[ds.length];
        int n = 0;
        while (n < ds.length) {
            res[n] = ds[n] + d;
            ++n;
        }
        return res;
    }

    public static int[] plus(int[] is, int i) {
        int[] res = new int[is.length];
        int n = 0;
        while (n < is.length) {
            res[n] = is[n] + i;
            ++n;
        }
        return res;
    }

    public static void writeMatrix(RealMatrix dm, BufferedWriter w, String colsep) throws IOException {
        double[][] dArray = dm.getData();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            w.write(Common.toString(row, "\t"));
            w.newLine();
            ++n2;
        }
        w.flush();
    }

    public static Mean filterValuesAbove(BlockRealMatrix upleftAll, double d) {
        Mean passed = new Mean();
        double[][] dArray = upleftAll.getData();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double[] dx;
            double[] dArray2 = dx = dArray[n2];
            int n3 = dx.length;
            int n4 = 0;
            while (n4 < n3) {
                double dxx = dArray2[n4];
                if (dxx <= d) {
                    passed.increment(dxx);
                }
                ++n4;
            }
            ++n2;
        }
        return passed;
    }

    public static <O> Set<O> subset(Set<O> input, double fraction) {
        HashSet<O> set = new HashSet<O>();
        if (fraction == 1.0) {
            return input;
        }
        int fullsize = (int)Math.round(fraction * (double)input.size());
        Iterator<O> iter = input.iterator();
        while (iter.hasNext() && set.size() < fullsize) {
            set.add(iter.next());
        }
        return set;
    }

    public static void copyfile(String srFile, String dtFile) {
        try {
            int len;
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            System.out.println("File copied.");
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.valueOf(ex.getMessage()) + " in the specified directory.");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void writeObjectToFile(Serializable o, File outFile) throws IOException {
        FileOutputStream oS = new FileOutputStream(outFile);
        ObjectOutputStream objO = new ObjectOutputStream(oS);
        objO.writeObject(o);
    }

    public static Object readObjectFromFile(File inFile) throws IOException, ClassNotFoundException {
        ObjectInputStream o_in = new ObjectInputStream(new FileInputStream(inFile));
        Object obj = o_in.readObject();
        return obj;
    }

    public static void exececuteCommand(String arg, boolean verboseFlag) {
        String s = null;
        try {
            Process p = Runtime.getRuntime().exec(arg);
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            if (verboseFlag) {
                System.out.println("Here is the standard error of the command (if any):\n");
                while ((s = stdError.readLine()) != null) {
                    System.out.println(s);
                }
            }
            int exitVal = p.waitFor();
        }
        catch (IOException e) {
            System.out.println("exception happened - here's what I know: ");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static double min(List<Double> list) {
        double r = Double.POSITIVE_INFINITY;
        for (double d : list) {
            if (!(d < r)) continue;
            r = d;
        }
        return r;
    }

    public static double max(List<Double> list) {
        double r = Double.NEGATIVE_INFINITY;
        for (double d : list) {
            if (!(d > r)) continue;
            r = d;
        }
        return r;
    }

    public static double max(Collection<Double> values) {
        double r = Double.NEGATIVE_INFINITY;
        for (double d : values) {
            if (!(d > r)) continue;
            r = d;
        }
        return r;
    }

    public static double min(Collection<Double> values) {
        double r = Double.POSITIVE_INFINITY;
        for (double d : values) {
            if (!(d < r)) continue;
            r = d;
        }
        return r;
    }

    public static double mean(Collection<Double> values) {
        double mean = 0.0;
        int valid = 0;
        for (double d : values) {
            if (Double.isNaN(d)) continue;
            mean += d;
            ++valid;
        }
        if (valid == 0) {
            return Double.NaN;
        }
        return mean / (double)valid;
    }

    public static String toString(byte[] bytearray) {
        StringBuffer b = new StringBuffer();
        byte[] byArray = bytearray;
        int n = bytearray.length;
        int n2 = 0;
        while (n2 < n) {
            byte d = byArray[n2];
            b.append((char)d);
            ++n2;
        }
        return b.toString();
    }

    public static double max(double[] is) {
        double max = Double.NEGATIVE_INFINITY;
        double[] dArray = is;
        int n = is.length;
        int n2 = 0;
        while (n2 < n) {
            double i = dArray[n2];
            if (max < i) {
                max = i;
            }
            ++n2;
        }
        return max;
    }

    public static double[][] abs(double[][] z) {
        double[][] out = new double[z.length][z[0].length];
        int i = 0;
        while (i < z.length) {
            out[i] = Common.abs(z[i]);
            ++i;
        }
        return out;
    }

    public static double max(double[][] is) {
        double max = Double.NEGATIVE_INFINITY;
        double[][] dArray = is;
        int n = is.length;
        int n2 = 0;
        while (n2 < n) {
            double[] i = dArray[n2];
            double x = Common.max(i);
            if (x > max) {
                max = x;
            }
            ++n2;
        }
        return max;
    }

    public static int[] argmax(double[][] is) {
        double max = Double.NEGATIVE_INFINITY;
        int[] idx = null;
        int rowidx = 0;
        while (rowidx < is.length) {
            double[] row = is[rowidx];
            int colidx = Common.argmax(row);
            if (is[rowidx][colidx] > max) {
                max = is[rowidx][colidx];
                idx = new int[]{rowidx, colidx};
            }
            ++rowidx;
        }
        return idx;
    }

    public static int argmax(double[] is) {
        double max = Double.NEGATIVE_INFINITY;
        int pos = -1;
        int idx = 0;
        while (idx < is.length) {
            double i = is[idx];
            if (max < i) {
                max = i;
                pos = idx;
            }
            ++idx;
        }
        return pos;
    }

    public static int argmin(double[] is) {
        double min = Double.POSITIVE_INFINITY;
        int pos = -1;
        int idx = 0;
        while (idx < is.length) {
            double i = is[idx];
            if (min > i) {
                min = i;
                pos = idx;
            }
            ++idx;
        }
        return pos;
    }

    public static <E> E[] shuffle(E[] s) {
        Object[] out = (Object[])s.clone();
        List<E> s_list = Common.toList(s);
        Random r = new Random();
        int i = 0;
        while (i < s.length) {
            int idx = r.nextInt(s_list.size());
            out[i] = s_list.get(idx);
            s_list.remove(idx);
            ++i;
        }
        return out;
    }

    public static void writeMatrix(BlockRealMatrix dm, StringBuffer w, String colsep) {
        double[][] dArray = dm.getData();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            w.append(Common.toString(row, "\t"));
            w.append(System.getProperty("line.separator"));
            ++n2;
        }
    }

    public static <T> T getLast(List<T> l) {
        return l.get(l.size() - 1);
    }

    public static double[] newDoubleArray(int length, double initVal) {
        double[] a = new double[length];
        int i = 0;
        while (i < length) {
            a[i] = initVal;
            ++i;
        }
        return a;
    }

    public static double[] merge(double[] starts, double[] ends) {
        double[] merged = new double[starts.length + ends.length];
        System.arraycopy(starts, 0, merged, 0, starts.length);
        System.arraycopy(ends, 0, merged, starts.length, ends.length);
        return merged;
    }

    public static double[] getNonZeroValues(double[] ds) {
        ArrayList<Double> a = new ArrayList<Double>();
        double[] dArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d != 0.0) {
                a.add(d);
            }
            ++n2;
        }
        return Common.toArray(a);
    }

    public static int firstValueAbove(double observedTestStatistic, double[] zC) {
        int minIdx = 0;
        int maxIdx = zC.length;
        int idx = (int)((double)(maxIdx - minIdx) / 2.0);
        while (maxIdx - minIdx > 1) {
            if (zC[idx] > observedTestStatistic) {
                maxIdx = idx;
            } else if (zC[idx] <= observedTestStatistic) {
                minIdx = idx;
            }
            idx = (int)((long)minIdx + Math.round((double)(maxIdx - minIdx) / 2.0));
        }
        return idx;
    }

    public static double sum(double[][] in) {
        double sum = 0.0;
        double[][] dArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            double[] d;
            double[] dArray2 = d = dArray[n2];
            int n3 = d.length;
            int n4 = 0;
            while (n4 < n3) {
                double dd = dArray2[n4];
                sum += dd;
                ++n4;
            }
            ++n2;
        }
        return sum;
    }

    public static double sum(double[] alpha) {
        double s = 0.0;
        double[] dArray = alpha;
        int n = alpha.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            s += d;
            ++n2;
        }
        return s;
    }

    public static <T> T[] merge(T[] c1, T[] c2) {
        T[] merged = Arrays.copyOf(c1, c1.length + c2.length);
        int i = c1.length;
        while (i < merged.length) {
            merged[i] = c2[i - c1.length];
            ++i;
        }
        return merged;
    }

    public static String toString(double[] d2, String sep, int decimalState) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < d2.length - 1) {
            b.append(String.valueOf(Common.setDecimalState(d2[i], decimalState)) + sep);
            ++i;
        }
        b.append(Common.setDecimalState(d2[i], decimalState));
        return b.toString();
    }
}

