% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_files.R
\name{open_files}
\alias{open_files}
\title{Open Multiple Files with Optional Menu Selection}
\usage{
open_files(file, open = interactive(), ...)
}
\arguments{
\item{file}{character: vector of file paths, where each path specifies the location of a file
to be opened or read; paths may be absolute or relative}

\item{open}{logical: Whether to open the files interactively (\code{TRUE}) or read their contents
programmatically (\code{FALSE}). Defaults to the result of \code{\link[=interactive]{interactive()}}.}

\item{...}{Additional arguments to be passed to the file opening or editing function;
these arguments are passed either to \code{\link[rstudioapi:navigateToFile]{rstudioapi::navigateToFile()}} or \code{\link[utils:edit]{utils::edit()}},
depending on the environment and the availability of the \code{rstudioapi} package.}
}
\value{
Returns an invisible named list. Each element corresponds to a file from the input vector, with the
value representing the result of the operation. When opening files, the result indicates success or failure.
When reading files, the result contains the file's contents. If "None" is selected, the function returns \code{NULL}.
}
\description{
The \code{open_files} function allows users to manage multiple files by either opening them interactively
or reading their contents programmatically. It supports interactive selection through a menu
for multiple file paths and adapts to the availability of the \code{rstudioapi} package for enhanced
integration with the RStudio IDE.
}
\details{
When the \code{file} argument contains more than one file path, the function calculates the
longest common subsequence (LCS) of the directory structures for all provided file paths
and presents the user with an interactive menu. The menu allows selection of files to open;
the options include "All," "None," or individual files that match the common directory pattern.
In non-interactive sessions, the function reads the content of the files instead.

Internally, the function determines whether the \code{rstudioapi} package is available, in which case
it uses \code{navigateToFile} for opening files within the RStudio IDE; otherwise, it falls back to the
base R function \code{edit}. In non-interactive sessions, the function reads file contents using
\code{readLines} and stores them in a named list, with filenames as the names of the list elements.

The auxiliary \code{lcss} function calculates the longest common subsequence of directory components
for the file paths; this helps in simplifying the user experience by grouping files with similar paths.

This documentation was created with the support of ChatGPT.
}
\examples{
if (interactive()) {
  files <- pkg.files("poylnomials", package="polynom")
  open_files(files[2]) # open one file
  open_files(files)    # open several files
}

}
