% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{sscore}
\alias{sscore}
\title{Standardized Score}
\usage{
sscore(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}
}
\value{
A numeric vector of standardized scores for each student. The scores follow
a standard normal distribution with:
\itemize{
\item Mean = 0
\item Standard deviation = 1
\item Approximately 68\% of scores between -1 and 1
\item Approximately 95\% of scores between -2 and 2
\item Approximately 99\% of scores between -3 and 3
}
}
\description{
The standardized score (z-score) indicates how far a student's performance
deviates from the mean in units of standard deviation. This function is
applicable only to binary response data.

The score is calculated by standardizing the passage rates:
\deqn{Z_i = \frac{r_i - \bar{r}}{\sigma_r}}
where:
\itemize{
\item \eqn{r_i} is student i's passage rate
\item \eqn{\bar{r}} is the mean passage rate
\item \eqn{\sigma_r} is the standard deviation of passage rates
}
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.

The standardization allows for comparing student performance across different
tests or groups. A positive score indicates above-average performance, while
a negative score indicates below-average performance.
}
\examples{
# using sample dataset
sscore(J5S10)
}
