% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgngcon.r
\name{fgngcon}
\alias{fgngcon}
\alias{lgngcon}
\alias{nlgngcon}
\alias{proflugngcon}
\alias{nlugngcon}
\alias{lgngcon}
\alias{fgngcon}
\alias{nlgngcon}
\alias{proflugngcon}
\alias{nlugngcon}
\alias{nlgngcon}
\alias{fgngcon}
\alias{lgngcon}
\alias{proflugngcon}
\alias{nlugngcon}
\alias{proflugngcon}
\alias{fgngcon}
\alias{lgngcon}
\alias{nlgngcon}
\alias{nlugngcon}
\alias{nlugngcon}
\alias{fgngcon}
\alias{lgngcon}
\alias{nlgngcon}
\alias{proflugngcon}
\title{MLE Fitting of Normal Bulk and GPD for Both Tails with 
 Single Continuity Constraint at Both Thresholds Extreme Value Mixture Model}
\usage{
fgngcon(x, phiul = TRUE, phiur = TRUE, ulseq = NULL, urseq = NULL,
  fixedu = FALSE, pvector = NULL, std.err = TRUE, method = "BFGS",
  control = list(maxit = 10000), finitelik = TRUE, ...)

lgngcon(x, nmean = 0, nsd = 1, ul = 0, xil = 0, phiul = TRUE,
  ur = 0, xir = 0, phiur = TRUE, log = TRUE)

nlgngcon(pvector, x, phiul = TRUE, phiur = TRUE, finitelik = FALSE)

proflugngcon(ulr, pvector, x, phiul = TRUE, phiur = TRUE, method = "BFGS",
  control = list(maxit = 10000), finitelik = TRUE, ...)

nlugngcon(pvector, ul, ur, x, phiul = TRUE, phiur = TRUE,
  finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{phiul}{probability of being below lower threshold \eqn{(0, 1)} or logical, see Details in 
help for \code{\link[evmix:fgng]{fgng}}}

\item{phiur}{probability of being above upper threshold \eqn{(0, 1)} or logical, see Details in 
help for \code{\link[evmix:fgng]{fgng}}}

\item{ulseq}{vector of lower thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{urseq}{vector of upper thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedu}{logical, should threshold be fixed (at either scalar value in \code{ulseq}/\code{urseq},
or estimated from maximum of profile likelihood evaluated at
sequence of thresholds in \code{ulseq}/\code{urseq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{nmean}{scalar normal mean}

\item{nsd}{scalar normal standard deviation (positive)}

\item{ul}{scalar lower tail threshold}

\item{xil}{scalar lower tail GPD shape parameter}

\item{ur}{scalar upper tail threshold}

\item{xir}{scalar upper tail GPD shape parameter}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}

\item{ulr}{vector of length 2 giving lower and upper tail thresholds or
\code{NULL} for default values}
}
\value{
Log-likelihood is given by \code{\link[evmix:fgngcon]{lgngcon}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fgngcon]{nlgngcon}}
  and \code{\link[evmix:fgngcon]{nlugngcon}}. Profile likelihood for both
  thresholds given by \code{\link[evmix:fgngcon]{proflugngcon}}. Fitting function
  \code{\link[evmix:fgngcon]{fgngcon}} returns a simple list with the
  following elements

\tabular{ll}{
 \code{call}:      \tab \code{optim} call\cr
 \code{x}:         \tab data vector \code{x}\cr
 \code{init}:      \tab \code{pvector}\cr
 \code{fixedu}:    \tab fixed thresholds, logical\cr
 \code{ulseq}:     \tab lower threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{urseq}:     \tab upper threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{nllhuseq}:  \tab profile negative log-likelihood at each threshold pair in (ulseq, urseq)\cr
 \code{optim}:     \tab complete \code{optim} output\cr
 \code{mle}:       \tab vector of MLE of parameters\cr
 \code{cov}:       \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:        \tab vector of standard errors of MLE of parameters\cr
 \code{rate}:      \tab \code{phiu} to be consistent with \code{\link[evd:fpot]{evd}}\cr
 \code{nllh}:      \tab minimum negative log-likelihood\cr
 \code{n}:         \tab total sample size\cr
 \code{nmean}:     \tab MLE of normal mean\cr
 \code{nsd}:       \tab MLE of normal standard deviation\cr
 \code{ul}:        \tab lower threshold (fixed or MLE)\cr
 \code{sigmaul}:   \tab MLE of lower tail GPD scale (estimated from other parameters)\cr
 \code{xil}:       \tab MLE of lower tail GPD shape\cr
 \code{phiul}:     \tab MLE of lower tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiul}:  \tab standard error of MLE of lower tail fraction\cr
 \code{ur}:        \tab upper threshold (fixed or MLE)\cr
 \code{sigmaur}:   \tab MLE of upper tail GPD scale (estimated from other parameters)\cr
 \code{xir}:       \tab MLE of upper tail GPD shape\cr
 \code{phiur}:     \tab MLE of upper tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiur}:  \tab standard error of MLE of upper tail fraction\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value 
mixture model with normal for bulk distribution between thresholds and conditional
GPDs for both tails with continuity at thresholds. With options for profile likelihood estimation for both thresholds and
fixed threshold approach.
}
\details{
The extreme value mixture model with normal bulk and GPD for both tails
with continuity at thresholds is 
fitted to the entire dataset using maximum likelihood estimation. The estimated
parameters, variance-covariance matrix and their standard errors are automatically
output.

See help for \code{\link[evmix:fnormgpd]{fnormgpd}} and 
\code{\link[evmix:fgng]{fgng}}for details, type \code{help fnormgpd} and \code{help fgng}. 
Only the different features are outlined below for brevity.

The GPD \code{sigmaul} and \code{sigmaur} parameters are now specified as function of
other parameters, see 
help for \code{\link[evmix:gngcon]{dgngcon}} for details, type \code{help gngcon}.
Therefore, \code{sigmaul} and \code{sigmaur} should not be included in the parameter
vector if initial values are provided, making the full parameter vector 
The full parameter vector is
(\code{nmean}, \code{nsd}, \code{ul}, \code{xil}, \code{ur}, \code{xir})
if thresholds are also estimated and
(\code{nmean}, \code{nsd}, \code{xil}, \code{xir})
for profile likelihood or fixed threshold approach.

If the profile likelihood approach is used, then a grid search over all combinations of both thresholds
is carried out. The combinations which lead to less than 5 in any datapoints beyond the thresholds are not considered.
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item MLE of normal parameters assuming entire population is normal; and
 \item lower threshold 10\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item upper threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD shape parameters beyond threshold. 
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}. Based on code
by Xin Zhao produced for MATLAB.
}

\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 1))

x = rnorm(1000)
xx = seq(-4, 4, 0.01)
y = dnorm(xx)

# Continuity constraint
fit = fgngcon(x)
hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dgngcon(xx, nmean, nsd, ul, xil, phiul,
   ur, xir, phiur), col="red"))
abline(v = c(fit$ul, fit$ur), col = "red")
  
# No continuity constraint
fit2 = fgng(x)
with(fit2, lines(xx, dgng(xx, nmean, nsd, ul, sigmaul, xil, phiul,
   ur, sigmaur, xir, phiur), col="blue"))
abline(v = c(fit2$ul, fit2$ur), col = "blue")
legend("topleft", c("True Density","No continuity constraint","With continuty constraint"),
  col=c("black", "blue", "red"), lty = 1)
  
# Profile likelihood for initial value of threshold and fixed threshold approach
fitu = fgngcon(x, ulseq = seq(-2, -0.2, length = 10), 
 urseq = seq(0.2, 2, length = 10))
fitfix = fgngcon(x, ulseq = seq(-2, -0.2, length = 10), 
 urseq = seq(0.2, 2, length = 10), fixedu = TRUE)

hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dgngcon(xx, nmean, nsd, ul, xil, phiul,
   ur, xir, phiur), col="red"))
abline(v = c(fit$ul, fit$ur), col = "red")
with(fitu, lines(xx, dgngcon(xx, nmean, nsd, ul, xil, phiul,
   ur, xir, phiur), col="purple"))
abline(v = c(fitu$ul, fitu$ur), col = "purple")
with(fitfix, lines(xx, dgngcon(xx, nmean, nsd, ul, xil, phiul,
   ur, xir, phiur), col="darkgreen"))
abline(v = c(fitfix$ul, fitfix$ur), col = "darkgreen")
legend("topright", c("True Density","Default initial value (90\% quantile)",
 "Prof. lik. for initial value", "Prof. lik. for fixed threshold"),
 col=c("black", "red", "purple", "darkgreen"), lty = 1)
}
  
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Normal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Hu, Y. (2013). Extreme value mixture modelling: An R package and simulation study.
MSc (Hons) thesis, University of Canterbury, New Zealand.
\url{http://ir.canterbury.ac.nz/simple-search?query=extreme&submit=Go}

Zhao, X., Scarrott, C.J. Reale, M. and Oxley, L. (2010). Extreme value modelling
for forecasting the market crisis. Applied Financial Econometrics 20(1), 63-72.

Mendes, B. and H. F. Lopes (2004). Data driven estimates for mixtures. Computational
Statistics and Data Analysis 47(3), 583-598.
}
\seealso{
\code{\link[stats:Normal]{dnorm}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}

Other normgpd normgpdcon gng gngcon fnormgpd fnormgpdcon fgng fgngcon: \code{\link{fgng}},
  \code{\link{fitmgng}}, \code{\link{fnormgpdcon}},
  \code{\link{fnormgpd}}, \code{\link{gngcon}},
  \code{\link{gng}}, \code{\link{itmgng}},
  \code{\link{normgpdcon}}, \code{\link{normgpd}}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
