% Generated by roxygen2 (4.0.1): do not edit by hand
\name{fgng}
\alias{fgng}
\alias{lgng}
\alias{nlgng}
\alias{nlugng}
\alias{proflugng}
\title{MLE Fitting of Normal Bulk and GPD for Both Tails Extreme Value Mixture Model}
\usage{
fgng(x, phiul = TRUE, phiur = TRUE, ulseq = NULL, urseq = NULL,
  fixedu = FALSE, pvector = NULL, std.err = TRUE, method = "BFGS",
  control = list(maxit = 10000), finitelik = TRUE, ...)

lgng(x, nmean = 0, nsd = 1, ul = 0, sigmaul = 1, xil = 0,
  phiul = TRUE, ur = 0, sigmaur = 1, xir = 0, phiur = TRUE,
  log = TRUE)

nlgng(pvector, x, phiul = TRUE, phiur = TRUE, finitelik = FALSE)

proflugng(ulr, pvector, x, phiul = TRUE, phiur = TRUE, method = "BFGS",
  control = list(maxit = 10000), finitelik = FALSE, ...)

nlugng(pvector, ul, ur, x, phiul = TRUE, phiur = TRUE, finitelik = FALSE)
}
\arguments{
\item{ul}{scalar lower tail threshold}

\item{sigmaul}{scalar lower tail GPD scale parameter (positive)}

\item{xil}{scalar lower tail GPD shape parameter}

\item{phiul}{probability of being below lower threshold \eqn{(0, 1)} or logical, see Details in
help for \code{\link[evmix:fgng]{fgng}}}

\item{ur}{scalar upper tail threshold}

\item{sigmaur}{scalar upper tail GPD scale parameter (positive)}

\item{xir}{scalar upper tail GPD shape parameter}

\item{phiur}{probability of being above upper threshold \eqn{(0, 1)} or logical, see Details in
help for \code{\link[evmix:fgng]{fgng}}}

\item{ulseq}{vector of lower thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{urseq}{vector of upper thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedu}{logical, should threshold be fixed (at either scalar value in \code{useq},
or estimated from maximum of profile likelihood evaluated at
sequence of thresholds in \code{useq})}

\item{ulr}{vector of length 2 giving lower and upper tail thresholds or
\code{NULL} for default values}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{nmean}{scalar normal mean}

\item{nsd}{scalar normal standard deviation (positive)}

\item{x}{vector of sample data}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}
}
\value{
Log-likelihood is given by \code{\link[evmix:fgng]{lgng}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fgng]{nlgng}}
  and \code{\link[evmix:fgng]{nlugng}}. Profile likelihood for both
  thresholds given by \code{\link[evmix:fgng]{proflugng}}. Fitting function
  \code{\link[evmix:fgng]{fgng}} returns a simple list with the
  following elements

\tabular{ll}{
 \code{call}:      \tab \code{optim} call\cr
 \code{x}:         \tab data vector \code{x}\cr
 \code{init}:      \tab \code{pvector}\cr
 \code{fixedu}:    \tab fixed thresholds, logical\cr
 \code{ulseq}:     \tab lower threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{urseq}:     \tab upper threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{optim}:     \tab complete \code{optim} output\cr
 \code{mle}:       \tab vector of MLE of parameters\cr
 \code{cov}:       \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:        \tab vector of standard errors of MLE of parameters\cr
 \code{rate}:      \tab \code{phiu} to be consistent with \code{\link[evd:fpot]{evd}}\cr
 \code{nllh}:      \tab minimum negative log-likelihood\cr
 \code{n}:         \tab total sample size\cr
 \code{nmean}:     \tab MLE of normal mean\cr
 \code{nsd}:       \tab MLE of normal standard deviation\cr
 \code{ul}:        \tab lower threshold (fixed or MLE)\cr
 \code{sigmaul}:   \tab MLE of lower tail GPD scale\cr
 \code{xil}:       \tab MLE of lower tail GPD shape\cr
 \code{phiul}:     \tab MLE of lower tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiul}:  \tab standard error of MLE of lower tail fraction\cr
 \code{ur}:        \tab upper threshold (fixed or MLE)\cr
 \code{sigmaur}:   \tab MLE of upper tail GPD scale\cr
 \code{xir}:       \tab MLE of upper tail GPD shape\cr
 \code{phiur}:     \tab MLE of upper tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiur}:  \tab standard error of MLE of upper tail fraction\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value
mixture model with normal for bulk distribution between thresholds and conditional
GPDs beyond thresholds. With options for profile likelihood estimation for both thresholds and
fixed threshold approach.
}
\details{
The extreme value mixture model with normal bulk and GPD for both tails is
fitted to the entire dataset using maximum likelihood estimation. The estimated
parameters, variance-covariance matrix and their standard errors are automatically
output.

See help for \code{\link[evmix:fnormgpd]{fnormgpd}} for details, type \code{help fnormgpd}.
Only the different features are outlined below for brevity.

The full parameter vector is
(\code{nmean}, \code{nsd}, \code{ul}, \code{sigmaul}, \code{xil}, \code{ur}, \code{sigmaur}, \code{xir})
if thresholds are also estimated and
(\code{nmean}, \code{nsd}, \code{sigmaul}, \code{xil}, \code{sigmaur}, \code{xir})
for profile likelihood or fixed threshold approach.

The tail fractions \code{phiul} and \code{phiur} are treated separately to the other parameters,
to allow for all their representations. In the fitting functions
\code{\link[evmix:fgng]{fgng}} and
\code{\link[evmix:fgng]{proflugng}} they are logical:
\itemize{
 \item default values \code{phiul=TRUE} and \code{phiur=TRUE} - tail fractions specified by
   normal distribution \code{pnorm(ul, nmean, nsd)} and survivior functions
   \code{1-pnorm(ur, nmean, nsd)} respectively and standard error is output as \code{NA}.
 \item \code{phiul=FALSE} and \code{phiur=FALSE} - treated as extra parameters estimated using
   the MLE which is the sample proportion beyond the thresholds and
   standard error is output.
}
In the likelihood functions \code{\link[evmix:fgng]{lgng}},
\code{\link[evmix:fgng]{nlgng}} and \code{\link[evmix:fgng]{nlugng}}
it can be logical or numeric:
\itemize{
 \item logical - same as for fitting functions with default values \code{phiul=TRUE} and \code{phiur=TRUE}.
 \item numeric - any value over range \eqn{(0, 1)}. Notice that the tail
   fraction probability cannot be 0 or 1 otherwise there would be no
   contribution from either tail or bulk components respectively. Also,
   \code{phiul+phiur<1} as bulk must contribute.
}
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item MLE of normal parameters assuming entire population is normal; and
 \item lower threshold 10\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item upper threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD parameters beyond threshold.
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}. Based on MATLAB
  code written by Xin Zhao.
}
\examples{
\dontrun{
par(mfrow=c(2,1))
x = rnorm(1000)
xx = seq(-4, 4, 0.01)
y = dnorm(xx)

# Bulk model based tail fraction
fit = fgng(x)
hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dgng(xx, nmean, nsd, ul, sigmaul, xil, phiul,
   ur, sigmaur, xir, phiur), col="red"))
abline(v = c(fit$ul, fit$ur), col = "red")

# Parameterised tail fraction
fit2 = fgng(x, phiul = FALSE, phiur = FALSE)
with(fit2, lines(xx, dgng(xx, nmean, nsd, ul, sigmaul, xil, phiul,
   ur, sigmaur, xir, phiur), col="blue"))
abline(v = c(fit2$ul, fit2$ur), col = "blue")
legend("topright", c("True Density","Bulk Tail Fraction","Parameterised Tail Fraction"),
  col=c("black", "red", "blue"), lty = 1)

# Profile likelihood for initial value of threshold and fixed threshold approach
fitu = fgng(x, ulseq = rep(seq(-2, -0.2, length = 10), times = 10),
 urseq = rep(seq(0.2, 2, length = 10), each = 10))
fitfix = fgng(x, ulseq = rep(seq(-2, -0.2, length = 10), times = 10),
 urseq = rep(seq(0.2, 2, length = 10), each = 10), fixedu = TRUE)

hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dgng(xx, nmean, nsd, ul, sigmaul, xil, phiul,
   ur, sigmaur, xir, phiur), col="red"))
abline(v = c(fit$ul, fit$ur), col = "red")
with(fitu, lines(xx, dgng(xx, nmean, nsd, ul, sigmaul, xil, phiul,
   ur, sigmaur, xir, phiur), col="purple"))
abline(v = c(fitu$ul, fitu$ur), col = "purple")
with(fitfix, lines(xx, dgng(xx, nmean, nsd, ul, sigmaul, xil, phiul,
   ur, sigmaur, xir, phiur), col="darkgreen"))
abline(v = c(fitfix$ul, fitfix$ur), col = "darkgreen")
legend("topright", c("True Density","Default initial value (90\% quantile)",
 "Prof. lik. for initial value", "Prof. lik. for fixed threshold"),
 col=c("black", "red", "purple", "darkgreen"), lty = 1)
}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Normal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Hu, Y. (2013). Extreme value mixture modelling: An R package and simulation study.
MSc (Hons) thesis, University of Canterbury, New Zealand.
\url{http://ir.canterbury.ac.nz/simple-search?query=extreme&submit=Go}

Zhao, X., Scarrott, C.J. Reale, M. and Oxley, L. (2010). Extreme value modelling
for forecasting the market crisis. Applied Financial Econometrics 20(1), 63-72.

Mendes, B. and H. F. Lopes (2004). Data driven estimates for mixtures. Computational
Statistics and Data Analysis 47(3), 583-598.
}
\seealso{
\code{\link[stats:Normal]{dnorm}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}

Other normgpd normgpdcon gng gngcon fnormgpd fnormgpdcon fgng fgngcon: \code{\link{dgngcon}},
  \code{\link{dgngcon}}, \code{\link{dgngcon}},
  \code{\link{dgngcon}}, \code{\link{dgngcon}},
  \code{\link{gngcon}}, \code{\link{gngcon}},
  \code{\link{gngcon}}, \code{\link{gngcon}},
  \code{\link{gngcon}}, \code{\link{pgngcon}},
  \code{\link{pgngcon}}, \code{\link{pgngcon}},
  \code{\link{pgngcon}}, \code{\link{pgngcon}},
  \code{\link{qgngcon}}, \code{\link{qgngcon}},
  \code{\link{qgngcon}}, \code{\link{qgngcon}},
  \code{\link{qgngcon}}, \code{\link{rgngcon}},
  \code{\link{rgngcon}}, \code{\link{rgngcon}},
  \code{\link{rgngcon}}, \code{\link{rgngcon}};
  \code{\link{dgng}}, \code{\link{dgng}},
  \code{\link{dgng}}, \code{\link{dgng}},
  \code{\link{dgng}}, \code{\link{gng}}, \code{\link{gng}},
  \code{\link{gng}}, \code{\link{gng}}, \code{\link{gng}},
  \code{\link{pgng}}, \code{\link{pgng}},
  \code{\link{pgng}}, \code{\link{pgng}},
  \code{\link{pgng}}, \code{\link{qgng}},
  \code{\link{qgng}}, \code{\link{qgng}},
  \code{\link{qgng}}, \code{\link{qgng}},
  \code{\link{rgng}}, \code{\link{rgng}},
  \code{\link{rgng}}, \code{\link{rgng}},
  \code{\link{rgng}}; \code{\link{ditmgng}},
  \code{\link{ditmgng}}, \code{\link{ditmgng}},
  \code{\link{ditmgng}}, \code{\link{ditmgng}},
  \code{\link{itmgng}}, \code{\link{itmgng}},
  \code{\link{itmgng}}, \code{\link{itmgng}},
  \code{\link{itmgng}}, \code{\link{pitmgng}},
  \code{\link{pitmgng}}, \code{\link{pitmgng}},
  \code{\link{pitmgng}}, \code{\link{pitmgng}},
  \code{\link{qitmgng}}, \code{\link{qitmgng}},
  \code{\link{qitmgng}}, \code{\link{qitmgng}},
  \code{\link{qitmgng}}, \code{\link{ritmgng}},
  \code{\link{ritmgng}}, \code{\link{ritmgng}},
  \code{\link{ritmgng}}, \code{\link{ritmgng}};
  \code{\link{dnormgpdcon}}, \code{\link{dnormgpdcon}},
  \code{\link{dnormgpdcon}}, \code{\link{dnormgpdcon}},
  \code{\link{dnormgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{rnormgpdcon}}, \code{\link{rnormgpdcon}},
  \code{\link{rnormgpdcon}}, \code{\link{rnormgpdcon}},
  \code{\link{rnormgpdcon}}; \code{\link{dnormgpd}},
  \code{\link{dnormgpd}}, \code{\link{dnormgpd}},
  \code{\link{dnormgpd}}, \code{\link{dnormgpd}},
  \code{\link{normgpd}}, \code{\link{normgpd}},
  \code{\link{normgpd}}, \code{\link{normgpd}},
  \code{\link{normgpd}}, \code{\link{pnormgpd}},
  \code{\link{pnormgpd}}, \code{\link{pnormgpd}},
  \code{\link{pnormgpd}}, \code{\link{pnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{rnormgpd}},
  \code{\link{rnormgpd}}, \code{\link{rnormgpd}},
  \code{\link{rnormgpd}}, \code{\link{rnormgpd}};
  \code{\link{fgngcon}}, \code{\link{fgngcon}},
  \code{\link{fgngcon}}, \code{\link{fgngcon}},
  \code{\link{fgngcon}}, \code{\link{lgngcon}},
  \code{\link{lgngcon}}, \code{\link{lgngcon}},
  \code{\link{lgngcon}}, \code{\link{lgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlugngcon}},
  \code{\link{nlugngcon}}, \code{\link{nlugngcon}},
  \code{\link{nlugngcon}}, \code{\link{nlugngcon}},
  \code{\link{proflugngcon}}, \code{\link{proflugngcon}},
  \code{\link{proflugngcon}}, \code{\link{proflugngcon}},
  \code{\link{proflugngcon}}; \code{\link{fitmgng}},
  \code{\link{fitmgng}}, \code{\link{fitmgng}},
  \code{\link{fitmgng}}, \code{\link{fitmgng}},
  \code{\link{litmgng}}, \code{\link{litmgng}},
  \code{\link{litmgng}}, \code{\link{litmgng}},
  \code{\link{litmgng}}, \code{\link{nleuitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nluitmgng}},
  \code{\link{nluitmgng}}, \code{\link{nluitmgng}},
  \code{\link{nluitmgng}}, \code{\link{nluitmgng}},
  \code{\link{profleuitmgng}}, \code{\link{profluitmgng}},
  \code{\link{profluitmgng}}, \code{\link{profluitmgng}},
  \code{\link{profluitmgng}}, \code{\link{profluitmgng}};
  \code{\link{fnormgpdcon}}, \code{\link{fnormgpdcon}},
  \code{\link{fnormgpdcon}}, \code{\link{fnormgpdcon}},
  \code{\link{fnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{lnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{lnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{nlunormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{nlunormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}}; \code{\link{fnormgpd}},
  \code{\link{fnormgpd}}, \code{\link{fnormgpd}},
  \code{\link{fnormgpd}}, \code{\link{fnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{lnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{lnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{nlunormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{nlunormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{proflunormgpd}},
  \code{\link{proflunormgpd}}, \code{\link{proflunormgpd}},
  \code{\link{proflunormgpd}}, \code{\link{proflunormgpd}}
}

