% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exi.R
\name{extremal}
\alias{extremal}
\alias{extremal0}
\title{Estimate extremal index using `intervals' method}
\usage{
extremal(x, y = NULL)

extremal0(x)
}
\arguments{
\item{x}{a logical vector or list of logical vectors}

\item{y}{an integer vector the same length as \code{x}; see Details}
}
\value{
A scalar estimate of the extremal index
}
\description{
Estimate extremal index using `intervals' method
}
\details{
Intervals estimator of extremal index based on Ferro and Segers (2003)'s moment-based estimator.

If \code{x} is supplied and \code{y} is not, \code{x} is assumed to identify consecutive threshold exceedances.
If \code{x} is supplied as a list, each list element is assumed to comprise identifiers of consecutive exceedances.
If \code{y} is supplied, \code{x} must be a logical vector, and \code{y} gives positions of \code{x} in
its original with-missing-values vector: so \code{y} identifies consecutive \code{x}.
For \code{extremal0} \code{x} must be a logical vector, as is assumed to identify consecutive threshold exceedances.
}
\examples{

n <- 1e2
x <- runif(n)
extremal0(x > .9)

y <- sort(sample(n, n - 5))
x <- x[y]
extremal(x > .9, y)

}
\references{
Ferro, C. A., & Segers, J. (2003). Inference for clusters of extreme values. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 65(2), 545-556.
}
