% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitEvent.R
\name{fitEvent}
\alias{fitEvent}
\title{Fit time-to-event model}
\usage{
fitEvent(df, event_model = "model averaging", npieces = 3)
}
\arguments{
\item{df}{The subject-level event data, including \code{time}
and \code{event}.}

\item{event_model}{The event model which specifies the type of event
model to be used in the analysis and can be set to one of the
following options: "exponential", "Weibull", "log-normal",
"piecewise exponential", or "model averaging", which uses the
\code{exp(-bic)} weighting and combines Weibull and
log-normal models. By default, it is set to "model
averaging".}

\item{npieces}{The number of pieces for the piecewise exponential
event model. By default, it is set to 3.}
}
\value{
A list of results from the model fit including key information
such as the event model, \code{model}, the estimated model parameters,
\code{theta}, the covariance matrix, \code{vtheta}, as well as the
Bayesian Information Criterion, \code{bic}.

If the piecewise exponential model is used, additional
variables will be included in the list of results, such as the
number of pieces, \code{npieces}, and the location
of knots used in the model, \code{knots}.

If the model averaging option is chosen, the weight assigned
to the Weibull component is indicated by the \code{w1} variable.
}
\description{
Fits a specified time-to-event model to the event data.
}
\examples{

event_fit <- fitEvent(df = observedData,
                      event_model = "piecewise exponential", npieces = 3)

}
