% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{ParamsListFullPL}
\alias{ParamsListFullPL}
\title{Wrapper for FullPL using a list for parameters in the exponential trawl case.}
\usage{
ParamsListFullPL(times, values, delta, params, logscale = T,
  transformation = F)
}
\arguments{
\item{times}{Vector of timestamps.}

\item{values}{Vector of target values.}

\item{delta}{Maximum depth of pairwise likelihood blocks. Should be positive
natural integer.}

\item{params}{List of parameters.}

\item{logscale}{Boolean to use logscale (log-likelihood). Default \code{T}.}

\item{transformation}{Boolean to use the Marginal Transform (MT) method.}
}
\value{
Pairwise Likelihood as per FullPL using a list of parameters instead.
}
\description{
Wrapper for FullPL using a list for parameters in the exponential trawl case.
}
\examples{
ParamsListFullPL(c(1,2,3,4,5), c(0, 2.3, .3, 0, 5), delta=2,
  params=list("alpha"=2,"beta"=3,"kappa"=1.5, "rho"=0.2), TRUE, FALSE)

}
