% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ethnoChordUser.R
\name{ethnoChordUser}
\alias{ethnoChordUser}
\title{Chord diagram of informants and species uses}
\source{
Whitney, C. W., Bahati, J., and Gebauer, J. (2018), Ethnobotany and agrobiodiversity; valuation of plants in the homegardens of southwestern Uganda. Ethnobiology Letters, 9(2), 90-100. <https://doi.org/10.14237/ebl.9.2.2018.503>
}
\usage{
ethnoChordUser(data)
}
\arguments{
\item{data}{is an ethnobotany data set with column 1 'informant' and 2 'sp_name' as row identifiers of informants and of species names respectively.
The rest of the columns are the identified ethnobotany use categories. The data should be populated with counts of uses per person (should be 0 or 1 values).}
}
\description{
Creates a chord diagram of informants and species uses for ethnobotany studies.
}
\examples{

#Use built-in ethnobotany data example
ethnoChordUser(ethnobotanydata)

#Generate random dataset of three informants uses for four species
eb_data <- data.frame(replicate(10,sample(0:1,20,rep=TRUE)))
names(eb_data) <- gsub(x = names(eb_data), pattern = "X", replacement = "Use_")  
eb_data$informant<-sample(c('User_1', 'User_2', 'User_3'), 20, replace=TRUE)
eb_data$sp_name<-sample(c('sp_1', 'sp_2', 'sp_3', 'sp_4'), 20, replace=TRUE)
ethnoChordUser(eb_data)

}
\keyword{chord}
\keyword{cultural}
\keyword{diagram}
\keyword{ethnobotany}
\keyword{quantitative}
\keyword{report}
\keyword{use}
\keyword{value}
