% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{ecdf_fun}
\alias{ecdf_fun}
\title{Computes the empirical cummulative distribution function for all groups
supplied by the formula.}
\usage{
ecdf_fun(data, formula, cuts = NULL)
}
\arguments{
\item{data}{The data frame used for estimation - ideally structured in a tidy 
format.}

\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups. Additional variables 
can be included with \code{+} to produce separate estimates by the secondary 
or tertiary variables of interest (e.g., \code{out ~ group + characteristic1 
+ characteristic2}).}

\item{cuts}{Optional vector of cut scores. If supplied, the ECDF will be
guaranteed to include these points. Otherwise, there could be gaps in the 
ECDF at those particular points (used in plotting the cut scores).}
}
\description{
Computes the empirical cummulative distribution function for all groups
supplied by the formula.
}
\keyword{internal}
