% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_plot.R
\name{pp_plot}
\alias{pp_plot}
\title{Produces the paired probability plot for two groups}
\usage{
pp_plot(formula, data, ref_group = NULL, annotate = FALSE, refline = TRUE,
  refline_col = "gray40", refline_lty = 2, refline_lwd = 2, text = NULL,
  text_size = 2, shade = NULL, shade_rgb = rgb(102, 178, 255, alpha = 30,
  maxColorValue = 255), legend = NULL, plot = TRUE, theme = NULL, ...)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note the
grouping variable must only include only two groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{ref_group}{Optional character vector (of length 1) naming the
reference group to be plotted on the x-axis. Defaults to the highest
scoring group.}

\item{annotate}{Logical. Defaults to \code{FALSE}. When \code{TRUE} and 
\code{legend == "side"} the plot is rendered such that additional
annotations can be made on the plot using low level base plotting functions
(e.g., \link[graphics]{arrows}). However, if set to \code{TRUE}, 
\link[grDevices]{dev.off} must be called before a new plot is rendered 
(i.e., close the current plotting window). Otherwise the plot will be
attempted to be rendered in the region designated for the legend). Argument
is ignored when \code{legend != "side"}.}

\item{refline}{Logical. Defaults to \code{TRUE}. Should a diagonal
reference line, representing the point of equal probabilities, be
   plotted?}

\item{refline_col}{Color of the reference line.}

\item{refline_lty}{Line type of the reference line.}

\item{refline_lwd}{Line width of the reference line.}

\item{text}{Logical. Should the \code{link{auc}} and \code{link{v}}
statistics be displayed on the plot? Defaults to \code{TRUE} when there
   are two groups. Cannot currently be displayed for more than two groups.}

\item{text_size}{The size of the text to be displayed. Defaults to 2.}

\item{shade}{Logical. Should the area under the curve be shaded? Defaults
to \code{TRUE} if there are only two group. Currently it cannot be 
produced for more than two groups.}

\item{shade_rgb}{The color of the shading via \link[grDevices]{rgb}. 
Defaults to \code{rgb(102, 178, 255, alpha = 30, max = 255)} which is a 
light blue color.}

\item{legend}{The type of legend to be displayed, with possible values 
\code{"base"}, \code{"side"}, or \code{"none"}. Defaults to \code{"side"}, 
when there are more than two groups and \code{"none"} when only comparing
two groups. If the option \code{"side"} is used the plot is split into two
plots, via \link[graphics]{layout}, with the legend displayed in the second 
plot. This scales better than the base legend (i.e., manually manipulating
the size of the plot after it is rendered), but is not compatible with 
multi-panel plotting (e.g., \code{par(mfrow = c(2, 2))} for a 2 by 2 plot).
When producing multi-panel plots, use \code{"none"} or \code{"base"}, the
latter of which produces the legend with the base \link[graphics]{legend}
function.}

\item{plot}{Logical. Should the plot be produced? Defaults to \code{TRUE}. 
Sometimes it is useful to only get the output from the plot, which is why
this functionality exists (likely to be implemented in a panel plot).}

\item{theme}{Visual properties of the plot. There are currently only two
themes implemented - a standard plot and a dark theme. If \code{NULL} 
(default), the theme will be produced with a standard white background. If
\code{"dark"}, a dark gray background will be used with white text and axes.}

\item{...}{Additional arguments passed to \link[graphics]{plot}. Note that
it is best to use the full argument rather than partial matching, given the
method used to call the plot. While some partial matching is supported 
(e.g., \code{m} for \code{main}, it is generally safest to supply the full
argument).}
}
\value{
The arguments supplied to the plot are silently returned for testing 
purposes.
}
\description{
The paired probability plot maps the probability of obtaining a specific
   score for each of two groups. The area under the curve 
   (\code{\link{auc}}) corresponds to the probability that a randomly
   selected observation from the x-axis group will have a higher score than
   a randomly selected observation from the y-axis group.
}
\examples{
# Prouduce default Probability-Probability plot with two groups
dev.off()
pp_plot(math ~ freelunch, star)

# Suppress shading and effect-size annotation
pp_plot(math ~ freelunch, 
		star, 
		shade = FALSE, 
		text = FALSE)

# Change color of shading & line, line width, and title
pp_plot(math ~ freelunch, 
		star, 
		shade_rgb = rgb(0.1, 0.8, 0.2, 0.5), 
		col = "purple", lwd = 5, 
		main = "Probability-Probability Plot")

# Change to dark theme
pp_plot(math ~ freelunch, star, theme = "dark")

# Produce default PP plot w/multiple groups
pp_plot(mean ~ grade, seda)

# Change reference group to third grade
pp_plot(mean ~ grade, 
		seda, 
		ref_group = "3")

}
