% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_tests.R
\name{lamb}
\alias{lamb}
\title{Lamb's parametric test (1995).}
\usage{
lamb(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item \code{mean}: an average abnormal return
    \item \code{lmb_stat}: a Lamb's test statistic
    \item \code{lmb_signif}: a significance of the statistic
}
}
\description{
An event study parametric test described in Lamb 1995.
}
\details{
Performs a parametric test for the event study, which is described in Lamb
1995. The author refers to Warner and Brown 1985 and Henderson
1990. However, this test was not observed in neither papers. The test
statistics are very close to the statistics produced by
\code{brown_warner_1985} and typically has the same significance. The test
examines the hypothesis whether the theoretical cross-sectional expected
value for a given day is equal to zero. It calculates statistics even if
event window and estimation period are overlapped (intersect). The critical
values are standard normal. The significance levels of \eqn{\alpha} are 0.1,
0.05, and 0.01 (marked respectively by *, **, and ***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^GSPC",
                                      start = as.Date("2019-04-01"),
                                      end = as.Date("2020-04-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("AMZN", "ZM", "UBER", "NFLX", "SHOP", "FB", "UPWK")
get_prices_from_tickers(tickers,
                        start = as.Date("2019-04-01"),
                        end = as.Date("2020-04-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2019-04-01"),
                       estimation_end = as.Date("2020-03-13")) \%>\%
    lamb(event_start = as.Date("2020-03-16"),
         event_end = as.Date("2020-03-20"))
}
## The result of the code above is equivalent to:
data(securities_returns)
lamb(list_of_returns = securities_returns,
     event_start =  as.Date("2020-03-16"),
     event_end = as.Date("2020-03-20"))

}
\references{
Lamb R.P. \emph{An Exposure-Based Analysis of Property-Liability
Insurer Stock Values around Hurricane Andrew}. Journal of Risk and Insurance,
62(1):111-123, 1995.
}
\seealso{
\code{\link{parametric_tests}}, \code{\link{brown_warner_1980}},
\code{\link{brown_warner_1985}}, \code{\link{t_test}},\code{\link{patell}}
and \code{\link{boehmer}}.
}
