% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_starprep.R
\name{starprep}
\alias{starprep}
\title{Prepare model fits for stargazer}
\usage{
starprep(..., stat = c("std.error", "statistic", "p.value", "ci", "df"),
  se_type = NULL, clusters = NULL, alpha = 0.05)
}
\arguments{
\item{...}{a list of lm_robust or lm objects}

\item{stat}{either "std.error" (the default), "statistic" (the t-statistic), "p.value", "ci", or "df"}

\item{se_type}{(optional) if any of the objects are lm objects, what standard
errors should be used. Must only be one type and will be used for all lm
objects passed to starprep. See \code{commarobust} for more.}

\item{clusters}{(optional) if any of the objects are lm objects, what clusters
should be used, if clusters should be used. Must only be one vector and will
be used for all lm objects passed to starprep. See \code{commarobust} for more.}

\item{alpha}{(optional) if any of the objects are lm objects, what significance level
should be used for the p-values or confidence intervals}
}
\value{
a list of vectors of extracted statistics for stargazers
}
\description{
Prepare model fits for stargazer
}
\details{
Used to help extract statistics from lists of model fits for stargazer.
Prefers lm_robust objects, but because \code{stargazer} does not work with \code{lm_robust}
objects, \code{starprep} can also take \code{lm} objects and calls \code{commarobust} to get
the preferred, robust statistics.
}
\examples{

library(stargazer)

lm1 <- lm(mpg ~ hp, data = mtcars)
lm2 <- lm(mpg ~ hp + wt, data = mtcars)

# Use default "HC2" standard errors
stargazer(lm1, lm2,
          se = starprep(lm1, lm2),
          p = starprep(lm1, lm2, stat = "p.value"),
          omit.stat = "f")
# NB: We remove the F-stat because stargazer only can use original F-stat
# which uses classical SEs

# Use default "CR2" standard errors with clusters
stargazer(lm1, lm2,
          se = starprep(lm1, lm2, clusters = mtcars$carb),
          p = starprep(lm1, lm2, clusters = mtcars$carb, stat = "p.value"),
          omit.stat = "f")

# Can also specify significance levels and different standard errors
stargazer(lm1, lm2,
          ci.custom = starprep(lm1, lm2, se_type = "HC3", alpha = 0.1, stat = "ci"),
          omit.stat = "f")

}
